% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/barplot.R
\docType{methods}
\name{barplot}
\alias{barplot}
\alias{barplot,CompositionMatrix-method}
\title{Barplot of Compositional Data}
\usage{
\S4method{barplot}{CompositionMatrix}(
  height,
  ...,
  order_columns = FALSE,
  order_rows = NULL,
  decreasing = TRUE,
  names = TRUE,
  space = 0.2,
  offset = 0.025,
  palette_color = palette_color_discrete(),
  border = NA,
  axes = TRUE,
  legend = TRUE
)
}
\arguments{
\item{height}{A \code{\linkS4class{CompositionMatrix}} object.}

\item{...}{Further graphical parameters.}

\item{order_columns}{A \code{\link{logical}} scalar: should should columns be reorderd?}

\item{order_rows}{An \code{\link{integer}} vector giving the index of the column to be
used for the ordering of the data.}

\item{decreasing}{A \code{\link{logical}} scalar: should the sort order of rows be
increasing or decreasing?}

\item{names}{A \code{\link{logical}} scalar: should row names be displayed?}

\item{space}{A length-one \code{\link{numeric}} vector giving the the amount of space
(as a fraction of the width of a bar) left between each bar
(defaults to \eqn{0.2}).}

\item{offset}{A length-one \code{\link{numeric}} vector giving the the amount of space
(as a fraction) left between groups (defaults to \eqn{0.025}). Only used if
\code{groups} is not \code{NULL}.}

\item{palette_color}{A palette \code{\link{function}} that when called with a single
argument returns a \code{character} vector of colors.}

\item{border}{The color to draw the borders.}

\item{axes}{A \code{\link{logical}} scalar: should axes be drawn on the plot?}

\item{legend}{A \code{\link{logical}} scalar: should the legend be displayed?}
}
\value{
\code{barplot()} is called for its side-effects: is results in a graphic being
displayed (invisibly return \code{height}).
}
\description{
Displays a compositional bar chart.
}
\examples{
## Data from Aitchison 1986
data("hongite")

## Coerce to compositional data
coda <- as_composition(hongite)

## Bar plot
barplot(coda)

## Data from Day et al. 2011
data("kommos", package = "folio")
kommos <- remove_NA(kommos, margin = 1) # Remove cases with missing values
coda <- as_composition(kommos, groups = 1) # Coerce to compositional data

## Use ceramic types for grouping
barplot(coda, order_columns = TRUE)

## Display only minor elements
minor <- coda[, is_element_minor(coda)]
barplot(minor, order_columns = TRUE)
}
\seealso{
Other plot methods: 
\code{\link{as_graph}()},
\code{\link{hist}()},
\code{\link{pairs}()},
\code{\link{plot}()}
}
\author{
N. Frerebeau
}
\concept{plot methods}
