% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/randomize_mask.R
\name{randomize_mask}
\alias{randomize_mask}
\title{Randomize Image based on Mask}
\usage{
randomize_mask(img, mask)
}
\arguments{
\item{img}{Object of class nifti with values to be randomized}

\item{mask}{Binary mask indicating which values should be randomized.}
}
\value{
Object of class nifti
}
\description{
Randomize the values within a mask
}
\examples{
  set.seed(5)
  dims = rep(10, 3)
  arr = array(rnorm(prod(dims)), dim = dims)
  nim = oro.nifti::nifti(arr)
  mask = abs(nim) > 1
  randomize_mask(nim, mask)
}
