% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getnetwork.R
\name{getnetwork}
\alias{getnetwork}
\title{getnetwork}
\usage{
getnetwork(tree, id = 1L, transform = "detect", ...)
}
\arguments{
\item{tree}{a networktree object}

\item{id}{the node in the tree to extract. Use summary(tree) to see
id numbers for each split}

\item{transform}{should stored correlation matrices be transformed to partial correlations 
or graphical lasso? Can be set to "cor", "pcor", or "glasso". Defaults to automatic detection}

\item{...}{arguments passed to qgraph (e.g., "tuning", "threshold")}
}
\description{
Easily extract a network from one of the 
nodes in a networktree object
}
\examples{

set.seed(1)
d <- data.frame(trend = 1:200, foo = runif(200, -1, 1))
d <- cbind(d, rbind(
  mvtnorm::rmvnorm(100, mean = c(0, 0, 0),
          sigma = matrix(c(1, 0.5, 0.5, 0.5, 1, 0.5, 0.5, 0.5, 1), ncol = 3)),
  mvtnorm::rmvnorm(100, mean = c(0, 0, 0),
          sigma = matrix(c(1, 0, 0.5, 0, 1, 0.5, 0.5, 0.5, 1), ncol = 3))
))
colnames(d)[3:5] <- paste0("y", 1:3)

## Now use the function
tree1 <- networktree(nodevars=d[,3:5], splitvars=d[,1:2])

getnetwork(tree1, id=1)

}
