% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sankeyNetwork.R
\name{sankeyNetwork}
\alias{sankeyNetwork}
\title{Create a D3 JavaScript Sankey diagram}
\source{
D3.js was created by Michael Bostock. See \url{http://d3js.org/} and, more
specifically for Sankey diagrams \url{http://bost.ocks.org/mike/sankey/}.
}
\usage{
sankeyNetwork(Links, Nodes, Source, Target, Value, NodeID, NodeGroup = NodeID,
  LinkGroup = NULL, units = "", colourScale = JS("d3.scale.category20()"),
  fontSize = 7, fontFamily = NULL, nodeWidth = 15, nodePadding = 10,
  margin = NULL, height = NULL, width = NULL)
}
\arguments{
\item{Links}{a data frame object with the links between the nodes. It should
have include the \code{Source} and \code{Target} for each link. An optional
\code{Value} variable can be included to specify how close the nodes are to
one another.}

\item{Nodes}{a data frame containing the node id and properties of the nodes.
If no ID is specified then the nodes must be in the same order as the
\code{Source} variable column in the \code{Links} data frame. Currently only
grouping variable is allowed.}

\item{Source}{character string naming the network source variable in the
\code{Links} data frame.}

\item{Target}{character string naming the network target variable in the
\code{Links} data frame.}

\item{Value}{character string naming the variable in the \code{Links} data
frame for how far away the nodes are from one another.}

\item{NodeID}{character string specifying the node IDs in the \code{Nodes}.
data frame. Must be 0-indexed.}

\item{NodeGroup}{character string specifying the node groups in the
\code{Nodes}. Used to color the nodes in the network.}

\item{LinkGroup}{character string specifying the groups in the
\code{Links}. Used to color the links in the network.}

\item{units}{character string describing physical units (if any) for Value}

\item{colourScale}{character string specifying the categorical colour
scale for the nodes. See
\url{https://github.com/mbostock/d3/wiki/Ordinal-Scales}.}

\item{fontSize}{numeric font size in pixels for the node text labels.}

\item{fontFamily}{font family for the node text labels.}

\item{nodeWidth}{numeric width of each node.}

\item{nodePadding}{numeric essentially influences the width height.}

\item{margin}{an integer or a named \code{list}/\code{vector} of integers
for the plot margins. If using a named \code{list}/\code{vector},
the positions \code{top}, \code{right}, \code{bottom}, \code{left}
are valid.  If a single integer is provided, then the value will be
assigned to the right margin. Set the margin appropriately
to accomodate long text labels.}

\item{height}{numeric height for the network graph's frame area in pixels.}

\item{width}{numeric width for the network graph's frame area in pixels.}
}
\description{
Create a D3 JavaScript Sankey diagram
}
\examples{
\dontrun{
# Recreate Bostock Sankey diagram: http://bost.ocks.org/mike/sankey/
# Load energy projection data
URL <- paste0('https://cdn.rawgit.com/christophergandrud/networkD3/',
              'master/JSONdata/energy.json')
energy <- jsonlite::fromJSON(URL)
# Plot
sankeyNetwork(Links = energy$links, Nodes = energy$nodes, Source = 'source',
             Target = 'target', Value = 'value', NodeID = 'name',
             units = 'TWh', fontSize = 12, nodeWidth = 30)

# Colour links
energy$links$energy_type <- sub(' .*', '',
                               energy$nodes[energy$links$source + 1, 'name'])

sankeyNetwork(Links = energy$links, Nodes = energy$nodes, Source = 'source',
Target = 'target', Value = 'value', NodeID = 'name',
LinkGroup = 'energy_type', NodeGroup = NULL)

}
}
\seealso{
\code{\link{JS}}
}

