\name{network.operators}
\alias{network.operators}
\alias{+.network}
\alias{-.network}
\alias{*.network}
\alias{!.network}
\alias{|.network}
\alias{&.network}
\alias{\%c\%}
\alias{\%c\%.network}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{ Network Operators }
\description{
 These operators allow for algebraic manipulation of relational structures.
}
\usage{
\method{+}{network}(e1, e2)
\method{-}{network}(e1, e2)
\method{*}{network}(e1, e2)
\method{\%c\%}{network}(e1, e2)
\method{!}{network}(e1)
\method{|}{network}(e1, e2)
\method{&}{network}(e1, e2)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{e1}{ an object of class \code{network}. }
  \item{e2}{ another \code{network}. }
}
\details{
  In general, the binary network operators function by producing a new network object whose edge structure is based on that of the input networks.  The properties of the new structure depend upon the inputs as follows:
  \itemize{
  \item The size of the new network is equal to the size of the input networks (for all operators save \code{\%c\%}), which must themselves be of equal size.  Likewise, the \code{bipartite} attributes of the inputs must match, and this is preserved in the output.
  \item If either input network allows loops, multiplex edges, or hyperedges, the output acquires this property.  (If both input networks do not allow these features, then the features are disallowed in the output network.)
  \item If either input network is directed, the output is directed; if exactly one input network is directed, the undirected input is treated as if it were a directed network in which all edges are reciprocated.
  \item Supplemental attributes (including vertex names, but not edgwise missingness) are not transferred to the output.
  }
  The unary operator acts per the above, but with a single input.  Thus, the output network has the same properties as the input, with the exception of supplemental attributes.

  The behavior of the composition operator, \code{\%c\%}, is somewhat more complex than the others.  In particular, it will return a bipartite network whenever either input network is bipartite \emph{or} the vertex names of the two input networks do not match (or are missing).  If both inputs are non-bipartite and have identical vertex names, the return value will have the same structure (but with loops).  This behavior corresponds to the interpretation of the composition operator as counting walks on labeled sets of vertices.

  Hypergraphs are not yet supported by these routines, but ultimately will be (as suggested by the above). 

  The specific operations carried out by these operators are generally self-explanatory in the non-multiplex case, but semantics in the latter circumstance bear elaboration.  The following summarizes the behavior of each operator:
  \describe{
    \item{\code{+}}{An \eqn{(i,j)} edge is created in the return graph for every \eqn{(i,j)} edge in each of the input graphs.}
    \item{\code{-}}{An \eqn{(i,j)} edge is created in the return graph for every \eqn{(i,j)} edge in the first input that is not matched by an \eqn{(i,j)} edge in the second input; if the second input has more \eqn{(i,j)} edges than the first, no \eqn{(i,j)} edges are created in the return graph.}
    \item{\code{*}}{An \eqn{(i,j)} edge is created for every pairing of \eqn{(i,j)} edges in the respective input graphs.}
    \item{\code{\%c\%}}{An \eqn{(i,j)} edge is created in the return graph for every edge pair \eqn{(i,k),(k,j)} with the first edge in the first input and the second edge in the second input.}
    \item{\code{!}}{An \eqn{(i,j)} edge is created in the return graph for every \eqn{(i,j)} in the input not having an edge.}
    \item{\code{|}}{An \eqn{(i,j)} edge is created in the return graph if either input contains an \eqn{(i,j)} edge.}
    \item{\code{&}}{An \eqn{(i,j)} edge is created in the return graph if both inputs contain an \eqn{(i,j)} edge.}
  }
  Semantics for missing-edge cases follow from the above, under the interpretation that edges with \code{na==TRUE} are viewed as having an unknown state.  Thus, for instance, \code{x*y} with \code{x} having 2 \eqn{(i,j)} non-missing and 1 missing edge and \code{y} having 3 respective non-missing and 2 missing edges will yield an output network with 6 non-missing and 9 missing \eqn{(i,j)} edges.  
}
\value{
   The resulting network.
}
\references{ Butts, C. T.  (2008).  \dQuote{network: a Package for Managing Relational Data in R.}  \emph{Journal of Statistical Software}, 24(2).  \url{http://www.jstatsoft.org/v24/i02/}

Wasserman, S. and Faust, K.  (1994).  \emph{Social Network Analysis: Methods and Applications.}  Cambridge: University of Cambridge Press. }
\author{ Carter T. Butts \email{buttsc@uci.edu} }
\note{ Currently, there is a naming conflict between the composition operator and the \code{\%c\%} operator in the \code{\link[sna]{sna}} package.  This will be resolved in future releases; for the time being, one can determine which version of \code{\%c\%} is in use by varying which package is loaded first.}

% ~Make other sections like Warning with \section{Warning }{....} ~

\seealso{ \code{\link{network.extraction}} }
\examples{
#Create an in-star
m<-matrix(0,6,6)
m[2:6,1]<-1
g<-network(m)
plot(g)

#Compose g with its transpose
gcgt<-g \%c\% (network(t(m)))
plot(gcgt)
gcgt

#Show the complement of g
!g

#Perform various arithmatic and logical operations
(g+gcgt)[,] == (g|gcgt)[,]             #All TRUE
(g-gcgt)[,] == (g&(!(gcgt)))[,]
(g*gcgt)[,] == (g&gcgt)[,]
}
\keyword{ math }% at least one, from doc/KEYWORDS
\keyword{ graphs }% __ONLY ONE__ keyword per line
