% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check.preservation.R
\name{is_preserved}
\alias{is_preserved}
\title{Check preservation}
\usage{
is_preserved(P, scores)
}
\arguments{
\item{P}{A partial ranking as matrix object calculated with \link{neighborhood_inclusion}
or \link{positional_dominance}.}

\item{scores}{Numeric vector containing the scores of a centrality index.}
}
\value{
Logical scaler whether \code{scores} preserves the relations in \code{P}.
}
\description{
Checks if a partial ranking is preserved in the ranking induced by \code{scores}.
}
\details{
In order for a score vector to preserve a partial ranking, the following
condition must be fulfilled:
\code{P[u,v]==1 & scores[i]<=scores[j]}.
}
\examples{

library(igraph)
# standard measures of centrality preserve the neighborhood inclusion preorder
data("dbces11")
P <- neighborhood_inclusion(dbces11)

is_preserved(P,degree(dbces11))
is_preserved(P,betweenness(dbces11))
is_preserved(P,closeness(dbces11))
}
\author{
David Schoch
}
