% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/network_functions.R
\name{network_functions}
\alias{network_functions}
\alias{node_jackknife}
\alias{network_jackknife}
\alias{absolute_threshold}
\alias{relative_threshold}
\title{Network Manipulation Functions}
\usage{
node_jackknife(Net)

network_jackknife(Net, network.variable)

absolute_threshold(Net, thresholds)

relative_threshold(Net, percentiles)
}
\arguments{
\item{Net}{Network to jackknife}

\item{network.variable}{Character name of node variable containing network labels}

\item{thresholds}{Vector of thresholds to use}

\item{percentiles}{Vector of densities to threshold at}
}
\value{
A \code{list} of \code{Net} objects
}
\description{
These functions take a \code{Net} object, manipulate the network in some way, and return a \code{list} of modified \code{Net} objects.

\code{node_jacknife}. Removes each node in turn from the \code{Net}, and returns a list of jackknifed \code{Net} objects.

\code{network_jackknife} - Removes each subnetwork in turn from the \code{Net}, and returns a list of jackknifed \code{Net} objects

\code{absolute_threshold} - Applies a series of absolute thresholding to target network, returning a binary network.

\code{relative_threshold} -  Applies a relative threshold based on target density to target network
}
\examples{
data(GroupA)
GroupA1_Net = as_Net(GroupA[[1]], "1", list(community = c(rep(1, 10), rep(2,10))))
node_jackknife(GroupA1_Net)
network_jackknife(GroupA1_Net, "community")
}
