% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/generateRandomNetwork.R
\name{generateRandomNetwork}
\alias{generateRandomNetwork}
\title{Generates a random graph in a hypercube.}
\usage{
generateRandomNetwork(n.points, n.dim = 2L, n.depots = NULL, lower = 0,
  upper = 100, name = NULL)
}
\arguments{
\item{n.points}{[\code{integer(1)}]\cr
Number of points.}

\item{n.dim}{[\code{integer(1)}]\cr
Number of dimensions. Default ist 2.}

\item{n.depots}{[\code{integer(1)}]\cr
Number of depots in instances for the Vehicle Routing Problem (VRP).
Default is NULL, i. e., no depots. The proceeding is as follows:
If \code{n.depots} is 1, a random cluster center is defined to be the depot.
If \code{n.depots} is 2, the second depot has maximal distance to the first.
By convention the depots are placed as the first nodes in the coordinates
matrix.}

\item{lower}{[\code{numeric(1)}]\cr
Lower box constraint of cube.}

\item{upper}{[\code{numeric(1)}]\cr
Upper box constraint of cube. Default is 100.}

\item{name}{[\code{character(1)} | \code{NULL}]\cr
Optional name for the generated network. Default is \code{NULL}. In this case
a random name is generated.}
}
\value{
[\code{Network}]
}
\description{
Generates a random graph in a hypercube.
}
\examples{
x = generateRandomNetwork(n.points = 100L, n.depots = 2L, upper = 50)
}

