% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diffnet-methods.R
\name{plot_diffnet}
\alias{plot_diffnet}
\title{Plot the diffusion process}
\usage{
plot_diffnet(graph, cumadopt, slices = NULL, undirected = TRUE,
  vertex.col = c("white", "red", "blue"), vertex.shape = c("square",
  "circle", "circle"), vertex.cex = "degree", label = NA,
  edge.col = "gray", mode = "fruchtermanreingold", layout.par = NULL,
  mfrow.par = NULL, main = "Network in period \%d",
  gmode = ifelse(undirected, "graph", "digraph"), lgd = list(x = "bottom",
  legend = c("Non-adopters", "New adopters", "Adopters"), pch = 21, bty = "n",
  cex = 1.2, horiz = TRUE), coords = NULL, vertex.frame.color = "gray",
  edge.arrow.size = 0.25, intra.space = c(0.15, 0.15), key.height = 0.1,
  rescale.fun = function(x) rescale_vertex_igraph(x, adjust = 100), ...)
}
\arguments{
\item{graph}{A dynamic graph (see \code{\link{netdiffuseR-graphs}}).}

\item{cumadopt}{\eqn{n\times T}{n*T} matrix.}

\item{slices}{Integer vector. Indicates what slices to plot. By default all are plotted.}

\item{undirected}{Logical scalar.}

\item{vertex.col}{A character vector of size 3 with colors names.}

\item{vertex.shape}{A character vector of size 3 with shape names.}

\item{vertex.cex}{Numeric vector of size \eqn{n}. Size of the vertices.}

\item{label}{Character vector of size \eqn{n}. If no provided, rownames of
the graph are used.}

\item{edge.col}{Character scalar/vector. Color of the edge.}

\item{mode}{Character scalar. Name of the layout algorithm to implement (see details).}

\item{layout.par}{Layout parameters (see details).}

\item{mfrow.par}{Vector of size 2 with number of rows and columns to be passed to \code{\link{par}.}}

\item{main}{Character scalar. A title template to be passed to \code{\link{sprintf}.}}

\item{gmode}{Character scalar. See \code{\link[sna:gplot]{gplot}.}}

\item{lgd}{List of arguments to be passed to \code{\link{legend}}.}

\item{coords}{Numeric matrix of size \eqn{n\times 2}{n * 2} with vertices coordinates.}

\item{vertex.frame.color}{Passed to \code{\link[igraph:plot.igraph]{plot.igraph}}}

\item{edge.arrow.size}{Passed to \code{\link[igraph:plot.igraph]{plot.igraph}}}

\item{intra.space}{Passed to \code{\link[igraph:plot.igraph]{plot.igraph}}}

\item{key.height}{Numeric scalar. Sets the proportion of the plot (y-axis) that the key uses.}

\item{rescale.fun}{A function to rescale vertex size. By defult it is set to be \code{\link{rescale_vertex_igraph}}}

\item{...}{Further arguments to be passed to \code{\link[igraph:plot.igraph]{plot.igraph}}.}
}
\value{
Calculated coordinates for the grouped graph (invisible).
}
\description{
Creates a colored network plot showing the structure of the graph through time
(one network plot for each time period)  and the set of adopter and non-adopters
in the network.
}
\details{
Plotting is done via the function \code{\link[sna:gplot]{gplot}},
and its layout via \code{\link[sna:gplot.layout]{gplot.layout}}, both from
the (\pkg{sna}) package.

In order to center the attention on the diffusion process itself, the
positions of each vertex are computed only once by aggregating the networks
through time, this is, instead of computing the layout for each time \eqn{t},
the function creates a new graph accumulating links through time.

The \code{mfrow.par} sets how to arrange the plots on the device. If \eqn{T=5}
and \code{mfrow.par=c(2,3)}, the first three networks will be in the top
of the device and the last two in the bottom.

The argument \code{vertex.col} contains the colors of non-adopters, new-adopters,
and adopters respectively. The new adopters (default color \code{"red"}) have a different
color that the adopters when the graph is at their time of adoption, hence,
when the graph been plotted is in \eqn{t=2} and \eqn{toa=2} the vertex will
be plotted in red.

\code{vertex.cex} can either be a numeric scalar, a numeric vector or a character
scalar taking any of the following values \code{"degree"}, \code{"indegree"}, or
\code{"outdegree"}. The later will be passed to \code{\link{dgr}} to calculate
degree of the cumulated graph and will be normalized as

\deqn{vertex.cex = [d - \min(d) + .1]/[\max(d) - \min(d) + .1]\times 2}{vertex.cex = [d - min(d) + .1]/[max(d) - min(d) + .1]* 2}

where \eqn{d=\sqrt{dgr(graph)}}{d=sqrt(dgr(graph))}.
}
\examples{
# Generating a random graph
set.seed(1234)
n <- 6
nper <- 5
graph <- rgraph_er(n,nper, p=.3, undirected = FALSE)
toa <- sample(2000:(2000+nper-1), n, TRUE)
adopt <- toa_mat(toa)

plot_diffnet(graph, adopt$cumadopt)
}
\author{
George G. Vega Yon
}
\seealso{
Other visualizations: \code{\link{diffusionMap}},
  \code{\link{drawColorKey}}, \code{\link{hazard_rate}},
  \code{\link{plot_adopters}}, \code{\link{plot_diffnet2}},
  \code{\link{plot_infectsuscep}},
  \code{\link{plot_threshold}},
  \code{\link{rescale_vertex_igraph}}
}
\keyword{hplot}

