% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/neon_index.R
\name{neon_index}
\alias{neon_index}
\title{Show information about all files downloaded to the local store}
\usage{
neon_index(
  product = NA,
  table = NA,
  site = NA,
  start_date = NA,
  end_date = NA,
  type = NA,
  ext = NA,
  timestamp = NA,
  hash = NULL,
  dir = neon_dir()
)
}
\arguments{
\item{product}{Include only files matching this NEON productCode(s)}

\item{table}{Include only files matching this table name (or regex pattern).
(optional).}

\item{site}{4-letter site code(s) to filter on. Leave as \code{NA} to search all.}

\item{start_date}{Download only files as recent as (\code{YYYY-MM-DD}). Leave
as \code{NA} to download up to the most recent available data.}

\item{end_date}{Download only files up to end_date (\code{YYYY-MM-DD}). Leave as
\code{NA} to download all prior data.}

\item{type}{Should we prefer the basic or expanded version of this product?
See details.}

\item{ext}{only match files with this file extension(s)}

\item{timestamp}{only match timestamps prior this. See details in \code{\link[=neon_index]{neon_index()}}.
Should be a datetime POSIXct object (or coerce-able string)}

\item{hash}{name of a hashing algorithm to check file integrity. Can be
\code{"md5"}, \code{"sha1"}, or \code{"sha256"} currently; or set to \link{NULL} (default)
to skip hash computation.}

\item{dir}{Location where files should be downloaded. By default will
use the appropriate applications directory for your system
(see \link[rappdirs:user_data_dir]{rappdirs::user_data_dir}).  This default also be configured by
setting the environmental variable \code{NEONSTORE_HOME}, see \link{Sys.setenv} or
\link{Renviron}.}
}
\description{
NEON products consist of several individual components, which are in turn
broken up by site and sampling month. By storing these individual files,
neonstore enables more reproducible workflows that can be traced back to
original, unaltered input data.  These atomized files can be quickly and easily
combined into unified tables, see \link{neon_read}.
}
\details{
File names include metadata such as the file productCode,
table name, site, and sampling month, as well as timestamp of creation.
\code{neon_index()} parses this metadata from the file name string and returns
the information in a convenient table, along with a path to each file.

\strong{Regarding timestamps:}  NEON will occasionally publish new versions of
previously-released raw data files (which may or may not actually differ).
The NEON download API, and hence \code{\link[=neon_download]{neon_download()}}, only serve the most recent
of such files, but earlier versions may still exist in your local \code{neonstore}
if you downloaded them before the updated files were released.  By default,
\code{\link[=neon_read]{neon_read()}} will always select the most recent of such files, thus avoiding
duplication and providing the most updated data.  For reproducibility however,
it may be necessary to access older version instead. Setting the timestamp
argument allows the user to filter out newer files and select the original
ones instead.  Unfortunately, at this time users cannot request the outdated
data files from NEON API.  For strict reproducibility, users should also
archive their local store.
}
\examples{

\dontshow{
# Hide setting tempfile, since a user would specify a persistent location
 Sys.setenv("NEONSTORE_HOME"=tempfile())
}

neon_index()

## Just bird survey product
neon_index("DP1.10003.001")

\dontshow{
# tidy
 Sys.unsetenv("NEONSTORE_HOME")
}

}
\seealso{
\code{\link[=neon_download]{neon_download()}}
}
