% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/results_summarize.R
\name{results_summarize}
\alias{results_summarize}
\title{Tabulate Measure Results}
\usage{
results_summarize(
  total_population,
  adult_population,
  peds_population,
  measure_name,
  population_names = c(total = "All", adult = "Adults", peds = "Peds"),
  numerator_col,
  ...
)
}
\arguments{
\item{total_population}{a dataframe or tibble containing the filtered and
calculated fields.}

\item{adult_population}{a dataframe or tibble containing the filtered and
calculated fields.}

\item{peds_population}{a dataframe or tibble containing the filtered and
calculated fields.}

\item{measure_name}{A string containing the measure description.}

\item{population_names}{A list containing the population descriptions.}

\item{numerator_col}{The tidyselect column containing the numerator.}

\item{...}{(optional) additional arguments}
}
\value{
Results tibble
}
\description{
Calculates measure numerator, denominator, and proportions for a NEMSQA
measure and each population.

Used throughout this package to calculate measure results.
}
\author{
Samuel Kordik, BBA, BS
}
