% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/var_tests.R
\name{var_tests}
\alias{var_tests}
\title{Variance Equality Tests}
\usage{
var_tests(xvar, group_by, dat = NULL, hush = FALSE, sep = ", ")
}
\arguments{
\item{xvar}{Either a numeric vector (numbers of any given variable), or, if
\code{dat} is given, a column name specifying the variable in the given data
frame.}

\item{group_by}{Either a vector of factors with which to group the \code{xvar}
values, or, if \code{dat} is given, one or more column names specifying the
columns in the given data frame.}

\item{dat}{Either \code{NULL} or a data frame from which the respective column
names should be selected for \code{xvar} and \code{group}.}

\item{hush}{Logical. If \code{TRUE}, prevents printing any details to console.}

\item{sep}{String (underscore \code{"_"} by default) for separating group
names.}
}
\value{
Prints test results.
}
\description{
Displayed sample sizes and SDs and performs Brown-Forsythe and
 Fligner-Killeen variance equality tests (tests of homogeneity of variances)
 per group combinations. This is primarily a subfunction of
 \code{\link{anova_neat}}, but here it is available separately for other
 potential purposes.
}
\note{
Brown-Forsythe test (i.e., Levene's test using medians) is calculated via
\code{\link[car:leveneTest]{car::leveneTest}}. Fligner-Killeen test, which may
be more robust (i.e., less affected by non-normal distribution), is calculated
via \code{\link[stats:fligner.test]{stats::fligner.test}}. (See also Conover
et al., 1981, p. 360.)
}
\examples{

data("ToothGrowth") # load base R example dataset

# the statistics of the four functions below should match
var_tests(ToothGrowth$len, ToothGrowth$supp)
var_tests('len', 'supp', ToothGrowth)
car::leveneTest(len ~ supp, data = ToothGrowth)
stats::fligner.test(len ~ supp, ToothGrowth)

# again the results below should match each other
var_tests(ToothGrowth$len,
          interaction(ToothGrowth$supp, ToothGrowth$dose))
var_tests('len', c('supp', 'dose'), ToothGrowth)
car::leveneTest(len ~ supp * as.factor(dose), data = ToothGrowth)
stats::fligner.test(len ~ interaction(supp, dose), ToothGrowth)

}
\references{
Brown, M. B. & Forsythe, A. B. (1974). Robust tests for the equality of
variances. Journal of the American Statistical Association, 69, pp. 364-367.

Conover W. J., Johnson M. E., & Johnson M. M. (1981). A comparative study of
tests for homogeneity of variances, with applications to the outer continental
shelf bidding data. Technometrics, 23, 351–361.

Fligner, M. A. & Killeen, T. J. (1976). Distribution-free two-sample tests for
scale. ‘Journal of the American Statistical Association. 71(353), 210-213.

Fox, J. & Weisberg, S. (2019) An R Companion to Applied Regression, Third
Edition, Sage.

Levene, H. (1960). Robust tests for equality of variances. In I. Olkin, H.
Hotelling, et al. (eds.). Contributions to Probability and Statistics: Essays
in Honor of Harold Hotelling. Stanford University Press. pp. 278–292.
}
\seealso{
\code{\link{anova_neat}}
}
