% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/white.R
\name{white}
\alias{white}
\title{Correlation Ratio based on Bell (1954) and White (1986)}
\usage{
white(
  geo_large = "county",
  geo_small = "tract",
  year = 2020,
  subgroup,
  omit_NAs = TRUE,
  quiet = FALSE,
  ...
)
}
\arguments{
\item{geo_large}{Character string specifying the larger geographical unit of the data. The default is counties \code{geo_large = "county"}.}

\item{geo_small}{Character string specifying the smaller geographical unit of the data. The default is census tracts \code{geo_large = "tract"}.}

\item{year}{Numeric. The year to compute the estimate. The default is 2020, and the years 2009 onward are currently available.}

\item{subgroup}{Character string specifying the racial/ethnic subgroup(s). See Details for available choices.}

\item{omit_NAs}{Logical. If FALSE, will compute index for a larger geographical unit only if all of its smaller geographical units have values. The default is TRUE.}

\item{quiet}{Logical. If TRUE, will display messages about potential missing census information. The default is FALSE.}

\item{...}{Arguments passed to \code{\link[tidycensus]{get_acs}} to select state, county, and other arguments for census characteristics}
}
\value{
An object of class 'list'. This is a named list with the following components:

\describe{
\item{\code{v}}{An object of class 'tbl' for the GEOID, name, and V at specified larger census geographies.}
\item{\code{v_data}}{An object of class 'tbl' for the raw census values at specified smaller census geographies.}
\item{\code{missing}}{An object of class 'tbl' of the count and proportion of missingness for each census variable used to compute V.}
}
}
\description{
Compute the aspatial Correlation Ratio (White) of a selected racial/ethnic subgroup(s) and U.S. geographies.
}
\details{
This function will compute the aspatial Correlation Ratio (V or \eqn{Eta^{2}}{Eta^2}) of selected racial/ethnic subgroups and U.S. geographies for a specified geographical extent (e.g., the entire U.S. or a single state) based on Bell (1954) \doi{10.2307/2574118} and White (1986) \doi{10.2307/3644339}. This function provides the computation of V for any of the U.S. Census Bureau race/ethnicity subgroups (including Hispanic and non-Hispanic individuals).

The function uses the \code{\link[tidycensus]{get_acs}} function to obtain U.S. Census Bureau 5-year American Community Survey characteristics used for the aspatial computation. The yearly estimates are available for 2009 onward when ACS-5 data are available but are available from other U.S. Census Bureau surveys. The twenty racial/ethnic subgroups (U.S. Census Bureau definitions) are:
\itemize{
\item \strong{B03002_002}: not Hispanic or Latino \code{"NHoL"}
\item \strong{B03002_003}: not Hispanic or Latino, white alone \code{"NHoLW"}
\item \strong{B03002_004}: not Hispanic or Latino, Black or African American alone \code{"NHoLB"}
\item \strong{B03002_005}: not Hispanic or Latino, American Indian and Alaska Native alone \code{"NHoLAIAN"}
\item \strong{B03002_006}: not Hispanic or Latino, Asian alone \code{"NHoLA"}
\item \strong{B03002_007}: not Hispanic or Latino, Native Hawaiian and Other Pacific Islander alone \code{"NHoLNHOPI"}
\item \strong{B03002_008}: not Hispanic or Latino, Some other race alone \code{"NHoLSOR"}
\item \strong{B03002_009}: not Hispanic or Latino, Two or more races \code{"NHoLTOMR"}
\item \strong{B03002_010}: not Hispanic or Latino, Two races including Some other race \code{"NHoLTRiSOR"}
\item \strong{B03002_011}: not Hispanic or Latino, Two races excluding Some other race, and three or more races \code{"NHoLTReSOR"}
\item \strong{B03002_012}: Hispanic or Latino \code{"HoL"}
\item \strong{B03002_013}: Hispanic or Latino, white alone \code{"HoLW"}
\item \strong{B03002_014}: Hispanic or Latino, Black or African American alone \code{"HoLB"}
\item \strong{B03002_015}: Hispanic or Latino, American Indian and Alaska Native alone \code{"HoLAIAN"}
\item \strong{B03002_016}: Hispanic or Latino, Asian alone \code{"HoLA"}
\item \strong{B03002_017}: Hispanic or Latino, Native Hawaiian and Other Pacific Islander alone \code{"HoLNHOPI"}
\item \strong{B03002_018}: Hispanic or Latino, Some other race alone \code{"HoLSOR"}
\item \strong{B03002_019}: Hispanic or Latino, Two or more races \code{"HoLTOMR"}
\item \strong{B03002_020}: Hispanic or Latino, Two races including Some other race \code{"HoLTRiSOR"}
\item \strong{B03002_021}: Hispanic or Latino, Two races excluding Some other race, and three or more races \code{"HoLTReSOR"}
}

Use the internal \code{state} and \code{county} arguments within the \code{\link[tidycensus]{get_acs}} function to specify geographic extent of the data output.

V removes the asymmetry from the Isolation Index (Bell) by controlling for the effect of population composition. The Isolation Index (Bell) is some measure of the probability that a member of one subgroup(s) will meet or interact with a member of another subgroup(s) with higher values signifying higher probability of interaction (less isolation). V can range in value from 0 to 1.

Larger geographies available include state \code{geo_large = "state"}, county \code{geo_large = "county"}, and census tract \code{geo_large = "tract"} levels. Smaller geographies available include, county \code{geo_small = "county"}, census tract \code{geo_small = "tract"}, and census block group \code{geo_small = "block group"} levels. If a larger geographical area is comprised of only one smaller geographical area (e.g., a U.S county contains only one census tract), then the V value returned is NA.
}
\examples{
\dontrun{
# Wrapped in \dontrun{} because these examples require a Census API key.
  
  # Isolation of non-Hispanic Black populations
  ## of census tracts within Georgia, U.S.A., counties (2020)
  white(geo_large = "county", geo_small = "tract", state = "GA",
        year = 2020, subgroup = "NHoLB")
  
}

}
\seealso{
\code{\link[tidycensus]{get_acs}} for additional arguments for geographic extent selection (i.e., \code{state} and \code{county}).
}
