% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CFAxisCharacter.R
\docType{class}
\name{CFAxisCharacter}
\alias{CFAxisCharacter}
\title{CF character axis object}
\description{
This class represent CF axes that use categorical character
labels as coordinate values. Note that this is different from a \link{CFLabel},
which is associated with an axis but not an axis itself.

This is an extension to the CF Metadata Conventions. As per CF, axes are
required to have numerical values, which is relaxed here.
}
\section{Super classes}{
\code{\link[ncdfCF:CFObject]{ncdfCF::CFObject}} -> \code{\link[ncdfCF:CFData]{ncdfCF::CFData}} -> \code{\link[ncdfCF:CFAxis]{ncdfCF::CFAxis}} -> \code{CFAxisCharacter}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{friendlyClassName}}{(read-only) A nice description of the class.}

\item{\code{dimnames}}{(read-only) The coordinates of the axis as a character
vector.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-CFAxisCharacter-new}{\code{CFAxisCharacter$new()}}
\item \href{#method-CFAxisCharacter-brief}{\code{CFAxisCharacter$brief()}}
\item \href{#method-CFAxisCharacter-copy}{\code{CFAxisCharacter$copy()}}
\item \href{#method-CFAxisCharacter-copy_with_values}{\code{CFAxisCharacter$copy_with_values()}}
\item \href{#method-CFAxisCharacter-slice}{\code{CFAxisCharacter$slice()}}
\item \href{#method-CFAxisCharacter-subset}{\code{CFAxisCharacter$subset()}}
\item \href{#method-CFAxisCharacter-identical}{\code{CFAxisCharacter$identical()}}
\item \href{#method-CFAxisCharacter-append}{\code{CFAxisCharacter$append()}}
\item \href{#method-CFAxisCharacter-indexOf}{\code{CFAxisCharacter$indexOf()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="ncdfCF" data-topic="CFObject" data-id="append_attribute"><a href='../../ncdfCF/html/CFObject.html#method-CFObject-append_attribute'><code>ncdfCF::CFObject$append_attribute()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ncdfCF" data-topic="CFObject" data-id="attribute"><a href='../../ncdfCF/html/CFObject.html#method-CFObject-attribute'><code>ncdfCF::CFObject$attribute()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ncdfCF" data-topic="CFObject" data-id="attributes_identical"><a href='../../ncdfCF/html/CFObject.html#method-CFObject-attributes_identical'><code>ncdfCF::CFObject$attributes_identical()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ncdfCF" data-topic="CFObject" data-id="delete_attribute"><a href='../../ncdfCF/html/CFObject.html#method-CFObject-delete_attribute'><code>ncdfCF::CFObject$delete_attribute()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ncdfCF" data-topic="CFObject" data-id="print_attributes"><a href='../../ncdfCF/html/CFObject.html#method-CFObject-print_attributes'><code>ncdfCF::CFObject$print_attributes()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ncdfCF" data-topic="CFObject" data-id="set_attribute"><a href='../../ncdfCF/html/CFObject.html#method-CFObject-set_attribute'><code>ncdfCF::CFObject$set_attribute()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ncdfCF" data-topic="CFObject" data-id="write_attributes"><a href='../../ncdfCF/html/CFObject.html#method-CFObject-write_attributes'><code>ncdfCF::CFObject$write_attributes()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ncdfCF" data-topic="CFData" data-id="dim"><a href='../../ncdfCF/html/CFData.html#method-CFData-dim'><code>ncdfCF::CFData$dim()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ncdfCF" data-topic="CFAxis" data-id="attach_to_group"><a href='../../ncdfCF/html/CFAxis.html#method-CFAxis-attach_to_group'><code>ncdfCF::CFAxis$attach_to_group()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ncdfCF" data-topic="CFAxis" data-id="can_append"><a href='../../ncdfCF/html/CFAxis.html#method-CFAxis-can_append'><code>ncdfCF::CFAxis$can_append()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ncdfCF" data-topic="CFAxis" data-id="configure_terms"><a href='../../ncdfCF/html/CFAxis.html#method-CFAxis-configure_terms'><code>ncdfCF::CFAxis$configure_terms()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ncdfCF" data-topic="CFAxis" data-id="copy_terms"><a href='../../ncdfCF/html/CFAxis.html#method-CFAxis-copy_terms'><code>ncdfCF::CFAxis$copy_terms()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ncdfCF" data-topic="CFAxis" data-id="detach"><a href='../../ncdfCF/html/CFAxis.html#method-CFAxis-detach'><code>ncdfCF::CFAxis$detach()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ncdfCF" data-topic="CFAxis" data-id="peek"><a href='../../ncdfCF/html/CFAxis.html#method-CFAxis-peek'><code>ncdfCF::CFAxis$peek()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ncdfCF" data-topic="CFAxis" data-id="print"><a href='../../ncdfCF/html/CFAxis.html#method-CFAxis-print'><code>ncdfCF::CFAxis$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ncdfCF" data-topic="CFAxis" data-id="shard"><a href='../../ncdfCF/html/CFAxis.html#method-CFAxis-shard'><code>ncdfCF::CFAxis$shard()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ncdfCF" data-topic="CFAxis" data-id="write"><a href='../../ncdfCF/html/CFAxis.html#method-CFAxis-write'><code>ncdfCF::CFAxis$write()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CFAxisCharacter-new"></a>}}
\if{latex}{\out{\hypertarget{method-CFAxisCharacter-new}{}}}
\subsection{Method \code{new()}}{
Create a new instance of this class.

Creating a new character axis is more easily done with the
\code{\link[=makeCharacterAxis]{makeCharacterAxis()}} function.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CFAxisCharacter$new(
  var,
  group,
  values,
  start = 1L,
  count = NA,
  attributes = data.frame()
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{var}}{The name of the axis when creating a new axis. When reading an
axis from file, the \link{NCVariable} object that describes this instance.}

\item{\code{group}}{The \link{CFGroup} that this instance will live in.}

\item{\code{values}}{Optional. The values of the axis in a vector. These must be
character values. Ignored when argument \code{var} is a NCVariable object.}

\item{\code{start}}{Optional. Integer index where to start reading axis data
from file. The index may be \code{NA} to start reading data from the start.}

\item{\code{count}}{Optional. Number of elements to read from file. This may be
\code{NA} to read to the end of the data.}

\item{\code{attributes}}{Optional. A \code{data.frame} with the attributes of the
axis. When an empty \code{data.frame} (default) and argument \code{var} is an
NCVariable instance, attributes of the axis will be taken from the
netCDF resource.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CFAxisCharacter-brief"></a>}}
\if{latex}{\out{\hypertarget{method-CFAxisCharacter-brief}{}}}
\subsection{Method \code{brief()}}{
Some details of the axis.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CFAxisCharacter$brief()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A 1-row \code{data.frame} with some details of the axis.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CFAxisCharacter-copy"></a>}}
\if{latex}{\out{\hypertarget{method-CFAxisCharacter-copy}{}}}
\subsection{Method \code{copy()}}{
Create a copy of this axis. The copy is completely separate
from this axis, meaning that the new axis and all of its components are
made from new instances. If this axis is backed by a netCDF resource,
the copy will retain the reference to the resource.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CFAxisCharacter$copy(name = "", group)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{The name for the new axis. If an empty string is passed, will
use the name of this axis.}

\item{\code{group}}{The \link{CFGroup} where the copy of this axis will live.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The newly created axis.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CFAxisCharacter-copy_with_values"></a>}}
\if{latex}{\out{\hypertarget{method-CFAxisCharacter-copy_with_values}{}}}
\subsection{Method \code{copy_with_values()}}{
Create a copy of this axis but using the supplied values.
The attributes are copied to the new axis. Boundary values and
auxiliary coordinates are not copied.

After this operation the attributes of the newly created axes may not
be accurate, except for the "actual_range" attribute. The calling code
should set, modify or delete attributes as appropriate.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CFAxisCharacter$copy_with_values(name = "", group, values)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{The name for the new axis. If an empty string is passed, will
use the name of this axis.}

\item{\code{group}}{The \link{CFGroup} where the copy of this axis will live.}

\item{\code{values}}{The values to the used with the copy of this axis.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The newly created axis.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CFAxisCharacter-slice"></a>}}
\if{latex}{\out{\hypertarget{method-CFAxisCharacter-slice}{}}}
\subsection{Method \code{slice()}}{
Given a range of domain coordinate values, returns the
indices into the axis that fall within the supplied range.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CFAxisCharacter$slice(rng)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{rng}}{A character vector whose extreme (alphabetic) values indicate
the indices of coordinates to return.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
An integer vector of length 2 with the lower and higher indices
into the axis that fall within the range of coordinates in argument
\code{rng}. Returns \code{NULL} if no values of the axis fall within the range of
coordinates.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CFAxisCharacter-subset"></a>}}
\if{latex}{\out{\hypertarget{method-CFAxisCharacter-subset}{}}}
\subsection{Method \code{subset()}}{
Return an axis spanning a smaller coordinate range. This
method returns an axis which spans the range of indices given by the
\code{rng} argument.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CFAxisCharacter$subset(name = "", group, rng = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{The name for the new axis. If an empty string is passed
(default), will use the name of this axis.}

\item{\code{group}}{The \link{CFGroup} where the copy of this axis will live.}

\item{\code{rng}}{The range of indices whose values from this axis to include in
the returned axis. If the value of the argument is \code{NULL}, return a
copy of the axis.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new \code{CFAxisCharacter} instance covering the indicated range of
indices. If the value of the argument \code{rng} is \code{NULL}, return a copy of
this axis as the new axis.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CFAxisCharacter-identical"></a>}}
\if{latex}{\out{\hypertarget{method-CFAxisCharacter-identical}{}}}
\subsection{Method \code{identical()}}{
Tests if the axis passed to this method is identical to
\code{self}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CFAxisCharacter$identical(axis)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{axis}}{The \code{CFAxisCharacter} instance to test.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if the two axes are identical, \code{FALSE} if not.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CFAxisCharacter-append"></a>}}
\if{latex}{\out{\hypertarget{method-CFAxisCharacter-append}{}}}
\subsection{Method \code{append()}}{
Append a vector of values at the end of the current values
of the axis.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CFAxisCharacter$append(from, group)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{from}}{An instance of \code{CFAxisCharacter} whose values to append to
the values of \code{self}.}

\item{\code{group}}{The \link{CFGroup} where the copy of this axis will live.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new \code{CFAxisCharacter} instance with values from \code{self} and the
\code{from} axis appended.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CFAxisCharacter-indexOf"></a>}}
\if{latex}{\out{\hypertarget{method-CFAxisCharacter-indexOf}{}}}
\subsection{Method \code{indexOf()}}{
Find indices in the axis domain. Given a vector of character
strings \code{x}, find their indices in the coordinates of the axis.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CFAxisCharacter$indexOf(x, method = "constant", rightmost.closed = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{Vector of character strings to find axis indices for.}

\item{\code{method}}{Ignored.}

\item{\code{rightmost.closed}}{Ignored.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Numeric vector of the same length as \code{x}. Values of \code{x} that are
not equal to a coordinate of the axis are returned as \code{NA}.
}
}
}
