% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NCObject.R
\docType{class}
\name{NCObject}
\alias{NCObject}
\title{NetCDF base object}
\description{
This class is a basic ancestor to all classes that represent
netCDF objects, specifically groups, dimensions, variables and the
user-defined types in a netCDF file. More useful classes use this class as
ancestor.
}
\details{
The fields in this class are common among all netCDF objects. In
addition, this class manages the attributes for its implementing classes.
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{id}}{Numeric identifier of the netCDF object.}

\item{\code{name}}{The name of the netCDF object.}

\item{\code{attributes}}{\code{data.frame} with the attributes of the netCDF object.
Create a new netCDF object

This class should not be instantiated directly, create descendant objects
instead.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-NCObject-new}{\code{NCObject$new()}}
\item \href{#method-NCObject-print_attributes}{\code{NCObject$print_attributes()}}
\item \href{#method-NCObject-attribute}{\code{NCObject$attribute()}}
\item \href{#method-NCObject-clone}{\code{NCObject$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-NCObject-new"></a>}}
\if{latex}{\out{\hypertarget{method-NCObject-new}{}}}
\subsection{Method \code{new()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{NCObject$new(id, name)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{id}}{Numeric identifier of the netCDF object.}

\item{\code{name}}{Character string with the name of the netCDF object.
Print the attributes of the netCDF object

This function prints the attributes of the netCDF object to the console.
Through object linkages, this also applies to the CF data variables and
axes, which each link to a netCDF object.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-NCObject-print_attributes"></a>}}
\if{latex}{\out{\hypertarget{method-NCObject-print_attributes}{}}}
\subsection{Method \code{print_attributes()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{NCObject$print_attributes(width = 50)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{width}}{The maximum width of each column in the \code{data.frame} when
printed to the console.
Attributes of a netCDF object

This method returns netCDF object attributes.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-NCObject-attribute"></a>}}
\if{latex}{\out{\hypertarget{method-NCObject-attribute}{}}}
\subsection{Method \code{attribute()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{NCObject$attribute(att, field = "value")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{att}}{Vector of attribute names whose values to return.}

\item{\code{field}}{The field of the attributes to return values from. This must
be "value" (default), "type" or "length".}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
If the \code{field} argument is "type' or "length", a vector named
with the \code{att} values that were found in the attributes. If argument
\code{field} is "value", a list with elements named with the \code{att} values,
containing the attribute value(s), except when argument \code{att} names a
single attribute, in which case that attribute value is returned as an
atomic object. If no attribute is named with a value of argument \code{att}
an empty list is returned, or an empty string if there was only one
value in argument \code{att}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-NCObject-clone"></a>}}
\if{latex}{\out{\hypertarget{method-NCObject-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{NCObject$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
