% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nbc4va_wrapper.R
\name{csmf.nbc}
\alias{csmf.nbc}
\title{Calculate predicted CSMFs from a NBC model}
\usage{
csmf.nbc(object)
}
\arguments{
\item{object}{The result \code{\link{nbc}} object.}
}
\value{
out A numeric vector of the predicted CSMFs in which the names are the corresponding causes.
}
\description{
Obtains the predicted Cause Specific Mortality Fraction (CSMF) from a result \code{\link{nbc}} object.
}
\examples{
library(nbc4va)
data(nbc4vaData)

# Run naive bayes classifier on random train and test data
train <- nbc4vaData[1:50, ]
test <- nbc4vaData[51:100, ]
results <- nbc(train, test)

# Obtain the predicted CSMFs
predCSMF <- csmf.nbc(results)

}
\seealso{
Other wrapper functions: \code{\link{topCOD.nbc}}
}

