% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/track.R
\name{emr_track.readonly}
\alias{emr_track.readonly}
\title{Gets or sets "read-only" property of a track}
\usage{
emr_track.readonly(track, readonly = NULL)
}
\arguments{
\item{track}{track name}

\item{readonly}{if 'NULL', return "readonlyness" of the track, otherwise
sets it}
}
\value{
None.
}
\description{
Gets or sets "readonly" property of a track.
}
\details{
This function gets or sets "readonly-ness" of the track. If 'readonly' is
'NULL' the functions returns whether the track is R/O. Otherwise it sets
"readonly-ness" to the value indicated by 'readonly'.

Logical tracks inherit their "readonly-ness" from the source
physical tracks.

Overriding a track also overrides it's "readonly-ness", it's
"readonly-ness" will persist when the track is no longer overridden
}
\seealso{
\code{\link{emr_track.create}}, \code{\link{emr_track.mv}},
\code{\link{emr_track.ls}}, \code{\link{emr_track.rm}}
}
\keyword{~track}
