% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter.R
\name{emr_filter.ls}
\alias{emr_filter.ls}
\title{Returns a list of named filters}
\usage{
emr_filter.ls(
  pattern = "",
  ignore.case = FALSE,
  perl = FALSE,
  fixed = FALSE,
  useBytes = FALSE
)
}
\arguments{
\item{pattern, ignore.case, perl, fixed, useBytes}{see 'grep'}
}
\value{
An array that contains the names of filters.
If no filter was found, \code{character(0)} would be returned.
}
\description{
Returns a list of named filters.
}
\details{
This function returns a list of named filters that exist in current R
environment that match the pattern (see 'grep'). If called without any
arguments all named filters are returned.
}
\examples{

emr_db.init_examples()
emr_filter.create("f1", "dense_track", time.shift = c(2, 4))
emr_filter.create("f2", "dense_track", keepref = TRUE)
emr_filter.ls()
emr_filter.ls("*2")
}
\seealso{
\code{\link{grep}}, \code{\link{emr_filter.exists}},
\code{\link{emr_filter.create}}, \code{\link{emr_filter.rm}}
}
\keyword{~filter}
\keyword{~ls}
