library(nanonext)
nanotest <- function(x) invisible(x || stop())
nanotestw <- function(x) invisible(suppressWarnings(x) || stop())
nanotestz <- function(x) invisible(x == 0L || stop())
nanotestn <- function(x) invisible(is.null(x) || stop())
nanotestnn <- function(x) invisible(!is.null(x) || stop())
nanotesterr <- function(x, e = "")
  invisible(grepl(e, tryCatch(x, error = identity)[["message"]], fixed = TRUE) || stop())

n <- nano("pair", listen = "inproc://nanonext", autostart = FALSE)
n1 <- nano("pair", dial = "inproc://nanonext", autostart = FALSE)
nanotest(inherits(n, "nanoObject"))
nanotest(inherits(n$socket, "nanoSocket"))
nanotest(inherits(n$socket, "nano"))
nanotest(is_nano(n))
n$newmethod <- "doesnotwork"
nanotestn(n$newmethod)
nanotest(is.integer(attr(n$socket, "id")))
nanotest(n$socket$state == "opened")
nanotest(n$socket$protocol == "pair")
nanotest(n$send("not ready") == 8L)
nanotest(n$recv() == 8L)
nanotestz(n$setopt("recv-size-max", 8192))
nanotest(n$getopt( "recv-size-max") == 8192L)
nanotestz(n$setopt("recv-buffer", 8))
nanotest(n$getopt("recv-buffer") == 8L)
nanotestz(n$setopt("socket-name", "nano"))
nanotest(n$getopt("socket-name") == "nano")
nanotestw(n$setopt("socket-name", NULL) == 3L)
n$listener[[1]]
nanotest(inherits(n$listener[[1]], "nanoListener"))
nanotest(n$listener[[1]]$url == "inproc://nanonext")
nanotest(n$listener[[1]]$state == "not started")
nanotestz(n$listener_setopt("recv-size-max", 1024)[[1L]])
nanotest(n$listener_getopt("recv-size-max")[[1L]] == 1024L)
nanotestw(n$listener_setopt("false", 100) == 9L)
nanotesterr(n$listener_getopt("false"), 9)
nanotestw(n$listener_setopt("false", "false") == 9L)
nanotestw(n$listener_setopt("false", NULL) == 9L)
nanotestw(n$listener_setopt("false", TRUE) == 9L)
nanotesterr(n$listener_setopt("false", list()), "type")
nanotestz(n$listener_start())
nanotest(n$listener[[1]]$state == "started")
n1$dialer[[1]]
nanotest(inherits(n1$dialer[[1]], "nanoDialer"))
nanotest(n1$dialer[[1]]$url == "inproc://nanonext")
nanotest(n1$dialer[[1]]$state == "not started")
nanotestz(n1$dialer_setopt("reconnect-time-min", 1000)[[1L]])
nanotest(n1$dialer_getopt("reconnect-time-min")[[1L]] == 1000L)
nanotestz(n1$dialer_setopt("recv-size-max", 8192)[[1L]])
nanotest(n1$dialer_getopt("recv-size-max")[[1L]] == 8192L)
nanotestw(n1$dialer_setopt("false", 100) == 9L)
nanotesterr(n1$dialer_getopt("false"), 9)
nanotestw(n1$dialer_setopt("false", "false") == 9L)
nanotestw(n1$dialer_setopt("false", NULL) == 9L)
nanotestw(n1$dialer_setopt("false", TRUE) == 9L)
nanotesterr(n1$dialer_setopt("false", list()), "type")
nanotestz(n1$dialer_start())
nanotest(n1$dialer[[1]]$state == "started")

nanotesterr(n$send(list(), mode = "raw"), "atomic vector type")
nanotesterr(n$recv(mode = "none"), "mode")
nanotesterr(n$recv(mode = "c"), "mode")
raio <- n$recv_aio(timeout = 1L)
raio
nanotest(is_error_value(call_aio(raio)$data))
nanotest(is_error_value(raio$data))
nanotestz(n$send(data.frame(), block = FALSE))
nanotest(is.list(n1$recv(block = FALSE, keep.raw = TRUE)))
nanotestz(n1$send("test", mode = "raw", block = 500))
nanotest(n$recv("character", block = 500, keep.raw = TRUE)$data == "test")
nanotestz(n1$send(c(1L, 0L, 0L), mode = "r"))
nanotest(is.list(n$recv("int", keep.raw = TRUE)))
saio <- n$send_aio(data.frame(), timeout = 500)
saio
nanotest(is_aio(call_aio(saio)))
nanotest(!is_nano(saio))
nanotest(is.integer(saio$result))
nanotesterr(n$send("wrong mode", mode = "none"), "mode")
raio <- n1$recv_aio(timeout = 500, keep.raw = TRUE)
raio
raio$newfield <- "doesnotwork"
nanotestn(raio$newfield)
nanotest(is_aio(raio))
saio <- n$send_aio(c(1.1, 2.2), mode = "raw", timeout = 500)
saio$newfield <- "doesnotwork"
nanotestn(saio$newfield)
nanotest(is_aio(saio))
nanotest(is.logical(unresolved(saio)))
nanotestnn(raio$raw)
nanotest(identical(unserialize(call_aio(raio)$raw), raio$data))
msg <- n1$recv_aio(mode = "numer", keep.raw = TRUE, timeout = 500)
nanotestn(stop_aio(msg))
nanotestn(stop_aio(n))
nanotest(identical(call_aio(msg), msg))
nanotesterr(msg$raw, "active")
nanotesterr(msg$data, "active")
nanotest(identical(call_aio(n), n))
nanotest(!is_aio(n))
sraio <- n$send_aio(as.raw(0L), mode = "r", timeout = 500)
rraio <- n1$recv_aio(mode = "r", timeout = 500)
nanotestnn(call_aio(rraio)$data)
sraio <- n$send_aio(c(1+2i, 4+3i), mode = "ra", timeout = 500)
rraio <- n1$recv_aio(mode = "co", timeout = 500)
nanotestnn(call_aio(rraio)$data)
sraio <- n$send_aio(5, mode = "raw", timeout = 500)
rraio <- n1$recv_aio(mode = "d", timeout = 500)
nanotestnn(call_aio(rraio)$data)
sraio <- n$send_aio(c(1, 2), mode = "raw", timeout = 500)
rraio <- n1$recv_aio(mode = "n", timeout = 500)
nanotestnn(call_aio(rraio)$data)
sraio <- n$send_aio(c(1L, 2L, 3L), mode = "raw", timeout = 500)
rraio <- n1$recv_aio(mode = "i", timeout = 500)
nanotestnn(call_aio(rraio)$data)
sraio <- n$send_aio(as.raw(0L), mode = "raw", timeout = 500)
rraio <- n1$recv_aio(mode = "double", timeout = 500)
nanotestw(is.raw(call_aio(rraio)$data))
sraio <- n$send_aio(as.raw(0L), mode = "raw", timeout = 500)
rraio <- n1$recv_aio(mode = "int", timeout = 500)
nanotestw(is.raw(call_aio(rraio)$data))
sraio <- n$send_aio(as.raw(0L), mode = "raw", timeout = 500)
rraio <- n1$recv_aio(mode = "logical", timeout = 500)
nanotestw(is.raw(call_aio(rraio)$data))
sraio <- n$send_aio(as.raw(0L), mode = "raw", timeout = 500)
rraio <- n1$recv_aio(mode = "numeric", timeout = 500)
nanotestw(is.raw(call_aio(rraio)$data))
sraio <- n$send_aio("hello", mode = 2L, timeout = 500)
assign("aio", value = "test", envir = sraio)
nanotesterr(sraio$result, "valid")
rraio <- n1$recv_aio(mode = "characte", keep.raw = TRUE, timeout = 500)
nanotesterr(setopt(rraio[["aio"]], "false", 0L), "valid")
nanotesterr(subscribe(rraio[["aio"]], "false"), "valid")
nanotesterr(getopt(rraio[["aio"]], "false"), "valid")
assign("aio", value = "test", envir = rraio)
nanotesterr(rraio$raw, "valid")
nanotesterr(rraio$data, "valid")

nanotestz(n$dial(url = "inproc://two", autostart = FALSE))
nanotestz(n$dialer_start())
nanotest(inherits(n$dialer[[1L]], "nanoDialer"))
nanotestz(n$listen(url = "inproc://three", autostart = FALSE))
nanotestz(n$listener_start())
nanotest(inherits(n$listener[[2L]], "nanoListener"))
nanotestz(close(n$listener[[1]]))
nanotestw(close(n$listener[[1]]) == 12L)
nanotestz(close(n1$dialer[[1]]))
nanotestw(close(n1$dialer[[1]]) == 12L)
nanotestz(n$close())
nanotestz(n1$close())
nanotestw(n1$close() == 7L)
nanotest(n$socket[["state"]] == "closed")
nanotest(n1$socket[state] == "closed")

req <- nano("req", listen = "inproc://testing")
rep <- socket("rep", dial = "inproc://testing", listen = "inproc://testing2")
rep
nanotestz(req$setopt("req:resend-time", 1000))
nanotest(req$getopt("req:resend-time") == 1000L)
nanotesterr(req$getopt("none"), 9)
nanotestnn(req$context_open())
nanotest(inherits(req$context, "nanoContext"))
nanotest(inherits(req$context, "nano"))
nanotest(is.integer(req$context$id))
nanotest(req$context$state == "opened")
nanotest(req$context$protocol == "req")
nanotestz(req$setopt("send-timeout", 1000))
nanotest(req$getopt("send-timeout") == 1000L)
nanotestw(req$setopt("false", 100) == 9L)
nanotesterr(req$getopt("false"), 9)
nanotestw(req$setopt("false", "false") == 9L)
nanotestw(req$setopt("false", NULL) == 9L)
nanotestw(req$setopt("false", TRUE) == 9L)
nanotesterr(req$setopt("false", list()), "type")
ctx <- context(rep)
ctx
csaio <- req$send_aio(data.frame(), mode = "seria", timeout = 500)
nanotestnn(call_aio(csaio)$result)
nanotestnn(recv_aio(ctx, timeout = 500))
nanotestnn(req$send("context test", mode ="raw", block = FALSE))
nanotestnn(recv(ctx, mode = "ch", block = FALSE))
nanotestnn(req$send(data.frame(), mode = "seri", block = 500))
msg <- recv_aio(ctx, mode = "ser", timeout = 500, keep.raw = FALSE)
nanotest(is.logical(unresolved(msg)))
nanotestnn(call_aio(msg)$data)
nanotest(!unresolved(msg))
nanotestnn(req$send(c(TRUE, FALSE, TRUE), mode = 2L, block = 500))
msg <- recv_aio(ctx, mode = 6L, timeout = 500, keep.raw = TRUE)
nanotestnn(call_aio(msg)$raw)
nanotestnn(msg$raw)
err <- send_aio(ctx, "test")
stop_aio(err)
nanotesterr(err$result, "active")
err <- send_aio(ctx, "test")
nanotest(is_error_value(call_aio(err)$result))
nanotestnn(request(req$context, c(1+3i, 4+2i), recv_mode = "complex", timeout = 500, keep.raw = TRUE))
nanotestnn(reply(ctx, execute = identity, send_mode = "ra", timeout = 500))
nanotestz(req$context_close())
nanotestn(req$context_close)
nanotestz(req$close())
nanotestn(req$context)
rep$dialer <- NULL
nanotestnn(rep$dialer)
nanotestz(close(ctx))
nanotestz(close(rep))

pub <- nano("pub", listen = "inproc://ps")
sub <- nano("sub", dial = "inproc://ps", autostart = NA)
nanotestz(sub$setopt(opt = "sub:prefnew", value = FALSE))
nanotest(!sub$getopt(opt = "sub:prefnew"))
nanotestw(sub$setopt(opt = "false", value = 100) == 9L)
nanotesterr(sub$getopt(opt = "false"), 9)
nanotesterr(sub$setopt(opt = "false", value = list()), "type")
nanotestz(sub$subscribe("test"))
nanotestz(subscribe(sub$socket, NULL))
nanotestz(sub$unsubscribe("test"))
nanotestnn(sub$context_open())
nanotest(inherits(sub$context, "nanoContext"))
nanotestz(sub$subscribe(12))
nanotestz(sub$unsubscribe(12))
nanotestz(sub$subscribe(NULL))
nanotestz(sub$context_close())
nanotestn(sub$context)
nanotestz(sub$close())
nanotestz(pub$close())

surv <- nano(protocol = "surveyor", listen = "inproc://sock1", dial = "inproc://sock2")
surv
resp <- nano(protocol = "respondent", listen = "inproc://sock2", dial = "inproc://sock1")
surv$dialer <- NULL
nanotestnn(surv$dialer)
nanotestnn(surv$listener)
nanotestz(surv$survey_time(time = 5000))
nanotestnn(surv$context_open())
nanotestnn(resp$context_open())
nanotestz(surv$survey_time(time = 2000))
nanotestz(surv$context_close())
nanotestz(resp$context_close())
nanotestz(surv$close())
nanotestz(resp$close())
nanotest(is_error_value(resp$recv(keep.raw = TRUE)$raw))

nanotest(inherits(bus <- socket(protocol = "bus"), "nanoSocket"))
nanotest(inherits(push <- socket(protocol = "push"), "nanoSocket"))
nanotest(inherits(pull <- socket(protocol = "pull"), "nanoSocket"))
nanotest(inherits(survey <- nano(protocol = "surveyor"), "nanoObject"))
nanotest(inherits(respond <- nano(protocol = "respondent"), "nanoObject"))
nanotest(is_nano(bus))
nanotestz(close(bus))
nanotestz(close(push))
nanotestz(close(pull))
nanotestz(survey$close())
nanotestz(respond$close())
nanotesterr(socket(protocol = "newprotocol"), "protocol")

nanotestnn(ncurl("http://www.cam.ac.uk/"))
nanotestnn(ncurl("http://www.cam.ac.uk/", follow = TRUE))
nanotestnn(ncurl("http://httpbin.org/post", convert = FALSE, method = "POST", headers = c(`Content-Type` = "text/plain"), data = "test", response = "server"))
nanotestnn(ncurl("http://httpbin.org/post", convert = FALSE, method = "POST", headers = list(`Content-Type` = "text/plain"), response = list("Date", "Server")))
relo <- ncurl("https://cran.r-project.org/package=nanonext", convert = FALSE, response = "server", async = TRUE)
nanotest(is.integer(call_aio(relo)$status))
relo <- ncurl("https://cran.r-project.org/package=nanonext", convert = FALSE, response = list("server"), async = TRUE)
nanotest(is.integer(call_aio(relo)$status))
put1 <- ncurl("http://httpbin.org/put", async = TRUE, method = "PUT", headers = c(Authorization = "Bearer token"), data = "test", response = c("date", "server"))
nanotest(is.integer(call_aio(put1)$status))
nanotestnn(put1$headers)
nanotestnn(put1$raw)
nanotestnn(put1$data)
put2 <- ncurl("http://httpbin.org/put", async = TRUE, method = "PUT", headers = list(Authorization = "Bearer token"), response = list("date", "server"))
put2
nanotest(is.integer(call_aio(put2)$status))
nanotest(is.null(stop_aio(put2)))
nanotest(is_error_value(ncurl("http")$raw))
nanotest(is_error_value(ncurl("http", async = TRUE)$data))
haio <- ncurl("https://i.i", async = TRUE)
nanotest(is_error_value(call_aio(haio)$raw))
haio$data
sess <- tryCatch(ncurl_session("https://httpbin.org/post", method = "POST", headers = c(`Content-Type` = "text/plain"), data = "test", response = "server"), error = identity)
nanotestnn(sess)
nanotest(if (!inherits(sess, "error")) length(transact(sess)) == 4L else TRUE)
sess <- tryCatch(ncurl_session("https://httpbin.org/post", convert = FALSE, method = "POST", headers = list(`Content-Type` = "text/plain"), response = list("Date", "Server")), error = identity)
nanotestnn(sess)
nanotest(if (!inherits(sess, "error")) length(transact(sess)) == 4L else TRUE)
nanotest(if (!inherits(sess, "error")) close(sess) == 0L else TRUE)
nanotesterr(transact(sess), "ncurlSession")
nanotesterr(ncurl_session("https://i.i"))
nanotesterr(stream(dial = "wss://127.0.0.1:5555"))
nanotesterr(stream(listen = "errorValue3"), 3)
nanotesterr(stream(), "specify")

nanotest(is.character(ver <- nng_version()) && length(ver) == 2L)
nanotest(nng_error(8L) == "Try again")
nanotest(is_nul_byte(as.raw(0L)))
nanotest(!is_nul_byte(NULL))
nanotest(!is_error_value(1L))
nanotesterr(messenger("invalidURL"), 3)
nanotest(is.double(mclock()))
nanotestn(msleep(1L))
nanotestn(msleep(1))
nanotestn(msleep("a"))
nanotest(is.double(random()))
nanotest(length(random(2)) == 2L)
nanotesterr(random("test"), "integer")
nanotesterr(device(push, pull), 7)
nanotesterr(device(ctx, push), "s1")
nanotesterr(device(push, ctx), "s2")
for (i in c(100:103, 200:208, 226, 300:308, 400:426, 428:431, 451, 500:511))
  nanotest(is.character(status_code(i)))

fakesock <- `class<-`(new.env(), "nanoSocket")
nanotesterr(dial(fakesock), "valid Socket")
nanotesterr(dial(fakesock, autostart = FALSE), "valid Socket")
nanotesterr(listen(fakesock), "valid Socket")
nanotesterr(listen(fakesock, autostart = FALSE), "valid Socket")
nanotesterr(context(fakesock), "valid Socket")
nanotesterr(close(fakesock), "valid Socket")
fakectx <- `class<-`("test", "nanoContext")
nanotesterr(request(fakectx, data = "test"), "valid Context")
nanotesterr(subscribe(fakectx, NULL), "valid")
nanotesterr(close(fakectx), "valid Context")
fakestream <- `class<-`("test", "nanoStream")
fakestream
fakesession <- `class<-`("test", "ncurlSession")
fakesession
nanotesterr(transact(fakesession), "valid")
nanotesterr(close(fakesession), "valid")
nanotesterr(send(fakestream, "test"), "valid")
nanotesterr(send_aio(fakestream, "test"), "valid")
nanotesterr(recv(fakestream), "valid")
nanotesterr(recv_aio(fakestream), "valid")
nanotesterr(setopt(fakestream, opt = "test", value = "test"), "valid")
nanotesterr(getopt(fakestream, opt = "test"), "valid")
nanotesterr(close(fakestream), "active Stream")
fakedial <- `class<-`("test", "nanoDialer")
nanotesterr(start(fakedial), "valid Dialer")
nanotesterr(close(fakedial), "valid Dialer")
fakelist <- `class<-`("test", "nanoListener")
nanotesterr(start(fakelist), "valid Listener")
nanotesterr(close(fakelist), "valid Listener")
unres <- `class<-`(NA, "unresolvedValue")
unres
nanotest(unresolved(unres))
nanotest(identical(call_aio("a"), "a"))
nanotestn(stop_aio("a"))

nanotest(sha256("test") == "9f86d081884c7d659a2feaa0c55ad015a3bf4f1b2b0b822cd15d6c15b0f00a08")
nanotest(length(sha256(c("one", "two"), key = "PRIVATE_key", convert = FALSE)) == 32L)
nanotest(nchar(sha512(c(1.1, 2.2), as.raw(1L))) == 128L)
nanotest(length(sha512("testing", convert = FALSE)) == 64L)
nanotest(length(sha384(data.frame(), "KEY", convert = FALSE)) == 48L)
nanotest(nchar(sha384(7000L, key = NULL, convert = TRUE)) == 96L)
nanotest(length(sha224(c("one", "two"), key = "PRIVATE_key", convert = FALSE)) == 28L)
nanotest(sha224(as.raw(0L)) == "fff9292b4201617bdc4d3053fce02734166a683d7d858a7f5f59b073")
nanotest(base64enc("test") == "dGVzdA==")
nanotest(base64dec(base64enc("test")) == "test")
nanotest(is.raw(base64enc(data.frame(), convert = FALSE)))
nanotest(is.integer(unserialize(base64dec(base64enc(c(1L, 2L)), convert = FALSE))))
nanotesterr(base64dec("__"), "not valid base64")

