% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opts.R
\name{getopt}
\alias{getopt}
\title{Get Option for a Socket, Context, Stream, Listener or Dialer}
\usage{
getopt(object, opt)
}
\arguments{
\item{object}{a Socket, Context, Stream, Listener or Dialer.}

\item{opt}{name of option, e.g. 'reconnect-time-min', as a character string.
See \link{opts}.}
}
\value{
The value of the option (logical for type 'bool', integer for 'int',
    'duration' and 'size', character for 'string' and double for 'uint64').
}
\description{
Get value of \link{opts} for a Socket, Context, Stream, Listener or Dialer.
}
\details{
To get options for a Listener or Dialer attached to a Socket or nano
    object, pass in the objects directly via for example \code{$listener[[1]]}
    for the first Listener.
}
\examples{
s <- socket("pair")
getopt(s, "send-buffer")
close(s)

s <- socket("req")
ctx <- context(s)
getopt(ctx, "send-timeout")
close(ctx)
close(s)

s <- socket("pair", dial = "inproc://nanonext", autostart = FALSE)
getopt(s$dialer[[1]], "reconnect-time-min")
close(s)

s <- socket("pair", listen = "inproc://nanonext", autostart = FALSE)
getopt(s$listener[[1]], "recv-size-max")
close(s)

}
