% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/protocol.R
\name{survey_time}
\alias{survey_time}
\alias{survey_time.nanoSocket}
\alias{survey_time.nanoContext}
\title{Set Survey Time}
\usage{
survey_time(con, time)

\method{survey_time}{nanoSocket}(con, time)

\method{survey_time}{nanoContext}(con, time)
}
\arguments{
\item{con}{a Socket or Context using the 'surveyor' protocol.}

\item{time}{the survey timeout in ms.}
}
\value{
Invisibly, an integer exit code (zero on success).
}
\description{
For a socket or context using the surveyor protocol in a surveyor/respondent
    pattern. Set a survey timeout in ms (remains valid for all subsequent
    surveys). Messages received by the surveyor after the timer has ended are
    discarded.
}
\details{
After using this function, to start a new survey, the surveyor must:
    \itemize{
    \item{send a message.}
    \item{switch to receiving responses.}
    }

    To respond to a survey, the respondent must:
    \itemize{
    \item{receive the survey message.}
    \item{send a reply using \code{\link{send_aio}} before the survey
    has timed out (a reply can only be sent after receiving a survey).}
    }
}
\examples{
sur <- socket("surveyor", listen = "inproc://nanonext")
res <- socket("respondent", dial = "inproc://nanonext")

survey_time(sur, 1000)
send(sur, "reply to this survey")
aio <- recv_aio(sur)

recv(res)
s <- send_aio(res, "replied")

call_aio(aio)$data

close(sur)
close(res)

}
