% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/protocol.R
\name{subscribe}
\alias{subscribe}
\title{Subscribe Topic}
\usage{
subscribe(socket, topic = NULL)
}
\arguments{
\item{socket}{a Socket using the sub protocol.}

\item{topic}{[default NULL] a topic (given as a character string). The default
NULL subscribes to all topics.}
}
\value{
Invisibly, an integer exit code (zero on success).
}
\description{
For a socket using the sub protocol in a publisher/subscriber pattern. Set a
    topic to subscribe to.
}
\details{
To use pub/sub the publisher must:
    \itemize{
    \item{specify \code{mode = 'raw'} when sending to allow the topics to be
    recognised by the receiving party.}
    \item{send a vector that separates the topic from the rest of the message
    e.g. \code{send(socket, c("topic", "message"), mode = "raw")} - this
    ensures that topic ends with the required nul byte for it to be
    recognised.}
    }
}
\examples{
pub <- socket("pub", listen = "inproc://nanonext")
sub <- socket("sub", dial = "inproc://nanonext")

subscribe(sub, "examples")
send(pub, c("examples", "this is an example"), mode = "raw")
recv(sub, "character")
send(pub, c("other", "this other topic will not be received"), mode = "raw")
recv(sub, "character")

close(pub)
close(sub)

}
