% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shadows.R
\name{shadow_long}
\alias{shadow_long}
\title{Reshape shadow data into a long format}
\usage{
shadow_long(shadow_data, ..., only_main_vars = TRUE)
}
\arguments{
\item{shadow_data}{a data.frame}

\item{...}{bare name of variables that you want to focus on}

\item{only_main_vars}{logical - do you want to filter down to main variables?}
}
\value{
data in long format, with columns \code{variable}, \code{value}, \code{variable_NA}, and \code{value_NA}.
}
\description{
Once data is in \code{nabular} form, where the shadow is bound to the data, it
can be useful to reshape it into a long format with the columns
}
\examples{

aq_shadow <- bind_shadow(airquality)

shadow_long(aq_shadow)

# then filter only on Ozone
shadow_long(aq_shadow, Ozone)

shadow_long(aq_shadow, Ozone, Solar.R)


}
