% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/na.replace.R
\name{na.replace}
\alias{na.replace}
\alias{na.explicit}
\title{Replace Missing Values}
\usage{
na.replace(x, .na, ...)

na.explicit(x)
}
\arguments{
\item{x}{vector in which \code{NA} values are to be replaced.}

\item{.na}{scalar, length(x)-vector or function used to replace \code{NA}. See #Details.}

\item{...}{additional arguments passed to \code{.na} when it is a function.}
}
\value{
A vector with the class and length of \code{x}.
\code{NA}s in \code{x} will be replaced by \code{.na}. \code{.na} is coerced as necessary.
}
\description{
Replaces \code{NA} values with explicit values.
}
\details{
\code{na.replace} replaces missing values in \code{x} by \code{.na} if possible.

In R, replacement of values can cause a change in the class/type of an object.
This is not often desired. \code{na.replace} is class/type-safe and length-safe.
It replaces missing values without changing the \code{x}'s class or length
regardless of the value provided by \code{.na}.

\strong{Param: \code{x}}

If \code{x} is \strong{categorical} (e.g. character or factor), \code{.na} is optional.
The default is "(NA)" and can be set with
\code{options( NA_explicit_ = new_value )}. It can also be
referenced directly with \link{NA_explicit_}.

If \code{x} is a \strong{factor}, unique values of \code{.na} not in already present in
\code{levels(x)} will be added. They are appended silently unless
\code{getOption('verbose')==TRUE} in which a message reports the added levels.

\strong{Param: \code{.na}}

\code{.na} can be either a scalar, vector or function.

If a \strong{scalar}, each missing value of \code{x} is replaced by \code{na}.

If a \strong{vector}, \code{.na} must have length(x)\code{. Missing values of}x\code{are replaced by corresponding elements of}.na\code{. Recycling values of}.na\code{is not allowed. An error will be thrown in the event that}length(.na)\code{is not}1\code{or}length(x)\code{.}

If a \strong{function}, \code{x} is transformed by .na` with:\preformatted{     .na(x, ...)
}

then preceding with normal operations.

\code{na.explicit} is an alias for na.replace that uses \link{NA_explicit_} for `.na``;
it returns x unchanged if it cannot change the value.
}
\examples{

  # Integers and numerics
  na.replace( c(1,NA,3,NA), 2 )    # 1 2 3 2   
  na.replace( c(1,NA,3,NA), 1:4 )  # 1 2 3 4

  # This produces an error because it would change the type
  \dontrun{
  na.replace( c(1,NA,3,NA), letters[1:4] )  # "1" "b" "3" "d"
  }
  
  # Characters 
  lets <- letters[1:5]
  lets[ c(2,4) ] <- NA
  na.replace(lets)  # replace with NA_explicit_

  # Factors 
  fct <- as.factor( c( NA, letters[2:4], NA) )
  fct
  na.replace(fct, "z")  # z b c d z  -- level z added
  na.replace(fct, letters[1:5] )
  na.replace(fct)
     
 \dontrun{
   na.replace( rep(NA,3), rep(NA,3) )
 }
     
}
\seealso{
\itemize{
\item \code{\link[base:ifelse]{base::ifelse()}}, \code{\link[base:replace]{base::replace()}}
\item \code{forcats::fct_explicit_na} - which only handles factors
}
}
