% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc.R
\name{mc_calc_gdd}
\alias{mc_calc_gdd}
\title{Growing Degree Days}
\usage{
mc_calc_gdd(data, sensor, output_prefix = "GDD", t_base = 5, localities = NULL)
}
\arguments{
\item{data}{cleaned myClim object see \link{myClim-package}}

\item{sensor}{name of temperature sensor used for GDD calculation e.g. TMS_T3 see \code{names(mc_data_sensors)}}

\item{output_prefix}{name prefix of new GDD sensor (default "GDD" -> "GDD5_TMS_T3")
name of output sensor consists of output_prefix and value t_base e.g. GDD5}

\item{t_base}{base temperature for calculation of GDD (default 5°C)}

\item{localities}{list of locality_ids for calculation; if NULL then all (default NULL)}
}
\value{
The same myClim object as input but with added virtual GDD sensor
}
\description{
This function creates new virtual sensor on the locality within myClim data object. The virtual sensor
with values of GDD (Growing Degree Days) in degees Celsius . days, using original time step. see details
}
\details{
Function calculates growing degree days as follows:  GDD = max(0;(T - Tbase)) . period(days)
The allowed time step length for GDD calculation is day and shorter.
Function creates new virtual sensor with the same time step as input data.
For shorter time steps than the day, the GDD value is the contribution
of the interval to the growing degree day, supposing constant temperature over this period.
Be careful while aggregating growing degree days to longer periods
\itemize{
\item only meaningful aggregation function is \code{sum},
but myClim let you apply anything see \code{\link[=mc_agg]{mc_agg()}}.
}
}
\examples{
gdd_data <- mc_calc_gdd(mc_data_example_agg, "TMS_T3", localities = c("A2E32", "A6W79"))
gdd_agg <- mc_agg(gdd_data, list(TMS_T3=c("min", "max"), GDD5="sum"), period="day")
}
