% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_var_proportions.R
\name{get_var_proportions}
\alias{get_var_proportions}
\title{Internal function to run variance proportions random effects modeling}
\usage{
get_var_proportions(mx_data, metadata_cols, table, m, formula_override, ...)
}
\arguments{
\item{mx_data}{\code{mx_dataset} object used to compute UMAP dimensions}

\item{metadata_cols}{other identifiers of the input \code{data} to use in the modeling process (default=NULL). This must be a vector of column name(s) in the \code{mx_dataset} object}

\item{table}{dataset in \code{mx_data} used to compute metrics. Options include: c("raw","normalized","both"), e.g. a y-axis parameter.}

\item{m}{marker to run \code{lme4} random effects model}

\item{formula_override}{String with user-defined formula to use for variance proportions modeling analysis (default=NULL). This will be the RHS of a formula with \verb{marker~} as the LHS.}

\item{...}{additional parameters to set for \code{lme4::lmer()} model.}
}
\value{
\code{lme4} model
}
\description{
Internal function to run variance proportions random effects modeling
}
