/*
 * Decompiled with CFR 0.152.
 */
package org.af.jhlir.tools;

import java.io.File;
import java.io.FileFilter;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.af.commons.io.FilterContains;
import org.af.commons.tools.OSTools;
import org.af.jhlir.tools.RegistryManager;

public class DirectoryGuesser {
    public static String searchDir(String[] search, String[] searchDir, String[] searchFile, boolean directory) {
        String result = "";
        for (String s : search) {
            String subresult;
            File dir = new File(s);
            if (!dir.exists() || (subresult = DirectoryGuesser.searchforFile(dir, searchDir, searchFile, directory)).equals("")) continue;
            result = subresult;
        }
        return result;
    }

    public static String searchforFile(File dir, String[] searchDir, String[] searchFile, boolean directory) {
        String result = "";
        File[] candidates = dir.listFiles((FileFilter)new FilterContains(searchDir));
        if (candidates == null || dir == null) {
            return "";
        }
        for (File f : candidates) {
            String subresult;
            if (f.isDirectory() == directory) {
                String name = f.getName().toUpperCase();
                for (String s : searchFile) {
                    if (name.indexOf(s) == -1) continue;
                    result = f.getAbsolutePath();
                }
            }
            if (!f.isDirectory() || (subresult = DirectoryGuesser.searchforFile(f, searchDir, searchFile, directory)).equals("")) continue;
            result = subresult;
        }
        return result;
    }

    public static File searchForFile(File dir, final List<String> searchFirst, Predicate pred) {
        List<File> candidates = Arrays.asList(dir.listFiles());
        Collections.sort(candidates, new Comparator<File>(){

            @Override
            public int compare(File o1, File o2) {
                int i2;
                int i1 = this.getSearchFirstIndex(o1.getName(), searchFirst);
                if (i1 == (i2 = this.getSearchFirstIndex(o2.getName(), searchFirst))) {
                    return o1.getName().compareTo(o2.getName());
                }
                return i2 - i1;
            }

            private int getSearchFirstIndex(String s, List<String> searchFirst2) {
                for (int i = 0; i < searchFirst2.size(); ++i) {
                    if (!s.contains(searchFirst2.get(i))) continue;
                    return i;
                }
                return -1;
            }
        });
        for (File f : candidates) {
            File result;
            if (pred.check(f)) {
                return f;
            }
            if (!f.isDirectory() || (result = DirectoryGuesser.searchForFile(f, searchFirst, pred)) == null) continue;
            return result;
        }
        return null;
    }

    public static String guessPDFViewerPath() {
        String[] search = new String[]{"C:\\Programme", "C:\\Program Files"};
        String[] searchDir = new String[]{"ADOBE", "ACR", "READER"};
        String[] searchFile = new String[]{"ACRORD32.EXE", "ACRORD64.EXE"};
        return DirectoryGuesser.searchDir(search, searchDir, searchFile, false);
    }

    public static String guessRHome() {
        if (System.getenv("R_HOME") != null) {
            return System.getenv("R_HOME");
        }
        if (OSTools.isWindows()) {
            String instPath = null;
            try {
                instPath = RegistryManager.getInstallPath();
            }
            catch (UnsatisfiedLinkError e) {
                e.printStackTrace();
            }
            if (instPath != null) {
                return instPath;
            }
            String[] search = new String[]{System.getenv("ProgramFiles")};
            String[] searchDir = new String[]{"R"};
            String[] searchFile = new String[]{"R-2."};
            return DirectoryGuesser.searchDir(search, searchDir, searchFile, true);
        }
        String path = "";
        if (OSTools.isLinux()) {
            path = DirectoryGuesser.guessRHomeUnix("rhome_linux.sh");
        } else if (OSTools.isMac()) {
            path = DirectoryGuesser.guessRHomeUnix("rhome_mac.sh");
        }
        File rhome = new File(path);
        if (rhome.exists()) {
            return rhome.getAbsolutePath();
        }
        return "";
    }

    private static String guessRHomeUnix(String script) {
        return "";
    }

    public static String guessJavaHome() {
        return System.getProperty("java.home");
    }

    public static String guessDesktop() {
        File desktop = new File(System.getProperty("user.home") + "/Desktop");
        if (desktop.exists()) {
            return desktop.getAbsolutePath();
        }
        return null;
    }

    public static class RHomeBinPredicate
    extends ContainsFilePredicate {
        public RHomeBinPredicate() {
            super("R.exe");
        }
    }

    public static class ContainsFilePredicate
    extends Predicate {
        private String containedFile;

        public ContainsFilePredicate(String f) {
            this.containedFile = f;
        }

        @Override
        boolean check(File f) {
            if (!f.exists() || !f.isDirectory()) {
                return false;
            }
            File cFile = new File(f, this.containedFile);
            return Arrays.asList(f.listFiles()).contains(cFile);
        }
    }

    public static abstract class Predicate {
        abstract boolean check(File var1);
    }
}

