/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.plaf.windows;

import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.image.BufferedImage;
import javax.imageio.ImageIO;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import org.jdesktop.swingx.JXStatusBar;
import org.jdesktop.swingx.plaf.UIManagerExt;
import org.jdesktop.swingx.plaf.basic.BasicStatusBarUI;

public class WindowsStatusBarUI
extends BasicStatusBarUI {
    private BufferedImage leftImage;
    private BufferedImage middleImage;
    private BufferedImage rightImage;

    public WindowsStatusBarUI() {
        try {
            this.leftImage = ImageIO.read(WindowsStatusBarUI.class.getResource(UIManagerExt.getString("StatusBar.leftImage")));
            this.middleImage = ImageIO.read(WindowsStatusBarUI.class.getResource(UIManagerExt.getString("StatusBar.middleImage")));
            this.rightImage = ImageIO.read(WindowsStatusBarUI.class.getResource(UIManagerExt.getString("StatusBar.rightImage")));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static ComponentUI createUI(JComponent c) {
        return new WindowsStatusBarUI();
    }

    protected void paintBackground(Graphics2D g, JXStatusBar statusBar) {
        g.drawImage(this.leftImage, 0, 0, this.leftImage.getWidth(), statusBar.getHeight(), null);
        g.drawImage(this.middleImage, this.leftImage.getWidth(), 0, statusBar.getWidth() - this.leftImage.getWidth() - this.rightImage.getWidth(), statusBar.getHeight(), null);
        g.drawImage(this.rightImage, statusBar.getWidth() - this.rightImage.getWidth(), 0, this.rightImage.getWidth(), statusBar.getHeight(), null);
    }

    protected Insets getSeparatorInsets(Insets insets) {
        if (insets == null) {
            insets = new Insets(0, 0, 0, 0);
        }
        insets.top = 1;
        insets.left = 4;
        insets.bottom = 0;
        insets.right = 4;
        return insets;
    }
}

