% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_theory.R
\name{sc}
\alias{sc}
\title{Set class from Forte's list}
\usage{
sc(card, num)
}
\arguments{
\item{card}{Integer value between 1 and 12 (inclusive)
that indicates the number of distinct pitch-classes in the set class.}

\item{num}{Ordinal number of the desired set class in Forte's list}
}
\value{
Numeric vector of length \code{card} representing a pc-set of \code{card} notes.
}
\description{
Given a cardinality and ordinal position, returns the (Rahn) prime form
of the set class from Allen Forte's list in \emph{The Structure of Atonal
Music} (1973). Draws the information from hard-coded values in the package's
data.
}
\examples{
ait1 <- sc(4, 15)
ait2 <- sc(4, 29)

NB_rahn_prime_form <- sc(6, 31)
print(NB_rahn_prime_form)
}
