% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_meanEMG.R
\name{plot_meanEMG}
\alias{plot_meanEMG}
\title{Plot EMG averaged across all cycles}
\usage{
plot_meanEMG(
  x,
  trial,
  row_number = NA,
  col_number = 1,
  dark_mode = FALSE,
  line_size = 0.6,
  line_col = "black",
  show_plot = TRUE
)
}
\arguments{
\item{x}{A data frame containing filtered EMG organised in columns}

\item{trial}{Character: the name of the considered trial, for archiving purposes}

\item{row_number}{How many rows should the final plot be divided into?}

\item{col_number}{How many columns should the final plot be divided into?}

\item{dark_mode}{To enable dark mode}

\item{line_size}{Line thickness}

\item{line_col}{Line colour}

\item{show_plot}{Logical, to decide whether plots should be plotted in the active graphic device}
}
\value{
Exports average filtered and normalised EMG.
}
\description{
Plot EMG averaged across all cycles
}
\details{
If \code{show_plot} is TRUE (default) plots are also shown in the active graphic device.
Plots can then be saved with the preferred export method, such as \code{ggplot2::ggsave}.
}
\examples{
# Load some data
data(FILT_EMG)

# Save a plot of the only present trial with the average filtered and time-normalised EMG
pp <- plot_meanEMG(FILT_EMG[[1]],
  trial = names(FILT_EMG)[1],
  row_number = 4,
  col_number = 4,
  dark_mode = TRUE,
  line_col = "tomato3",
  show_plot = FALSE
)
}
