\name{MTP-class}
\docType{class}
\alias{MTP-class}

\title{Class "MTP", classes and methods for multiple testing procedure output}

\description{An object of class MTP is the output of a particular multiple testing procedure, for example, generated by the MTP function. It has slots for the various data used to make multiple testing decisions, such as adjusted p-values and confidence regions.}

\section{Objects from the Class}{
Objects can be created by calls of the form \cr
new('MTP', \cr
	statistic = ...., object of class numeric\cr
	estimate  = ...., object of class numeric\cr
	sampsize  = ...., object of class numeric\cr
	rawp      = ...., object of class numeric\cr
	adjp      = ...., object of class numeric\cr
	conf.reg  = ...., object of class array\cr
        cutoff    = ...., object of class matrix\cr
 	reject	  = ...., object of class matrix\cr
        nulldist  = ...., object of class matrix\cr
        call      = ...., object of class call\cr
        seed      = ...., object of class integer\cr
       )
}

\section{Slots}{
  \describe{
    \item{\code{statistic}:}{Object of class \code{numeric}, observed test statistics for each hypothesis, specified by the values of the \code{MTP} arguments \code{test}, \code{robust}, \code{standardize}, and \code{psi0}.}
    \item{\code{estimate}:}{For the test of single-parameter null hypotheses using t-statistics (i.e., not the F-tests), the numeric vector of estimated parameters corresponding to each hypothesis, e.g. means, differences in means, regression parameters.}
    \item{\code{sampsize}:}{Object of class \code{numeric}, number of columns (i.e. observations) in the input data set.}
    \item{\code{rawp}:}{Object of class \code{numeric}, unadjusted, marginal p-values for each hypothesis.}
    \item{\code{adjp}:}{Object of class \code{numeric}, adjusted (for multiple testing) p-values for each hypothesis (computed only if the \code{get.adjp} argument is TRUE).}
    \item{\code{conf.reg}:}{For the test of single-parameter null hypotheses using t-statistics (i.e., not the F-tests), the numeric array of lower and upper simultaneous confidence limits for the parameter vector, for each value of the nominal Type I error rate \code{alpha} (computed only if the \code{get.cr} argument is TRUE).}
    \item{\code{cutoff}:}{The numeric matrix of cut-offs for the vector of test statistics for each value of the nominal Type I error rate \code{alpha} (computed only if the \code{get.cutoff} argument is TRUE).}
   \item{\code{reject}:}{Object of class \code{matrix}, rejection indicators (TRUE for a rejected null hypothesis), for each value of the nominal Type I error rate \code{alpha}.}
    \item{\code{nulldist}:}{The numeric matrix for the estimated test statistics null distribution (returned only if \code{keep.nulldist=TRUE}; option not currently available for permutation null distribution, i.e.,  \code{nulldist="perm"}). By default (i.e., for \code{nulldist="boot"}), the entries of \code{nulldist} are the null value shifted and scaled bootstrap test statistics, with one null test statistic value for each hypothesis (rows) and bootstrap iteration (columns).}
   \item{\code{call}:}{Object of class \code{call}, the call to the MTP function.}
    \item{\code{seed}:}{An integer for specifying the state of the random number generator used to create the resampled datasets. The seed can be reused for reproducibility in a repeat call to \code{MTP}. This argument is currently used only for the bootstrap null distribution (i.e., for \code{nulldist="boot"}). See \code{? set.seed} for details.}
  }
}

\section{Methods}{
 \code{signature(x = "MTP")} \cr
 \describe{
    \item{[}{: Subsetting method for \code{MTP} class, which operates selectively on each slot of an \code{MTP} instance to retain only the data related to the specified hypotheses.}

    \item{as.list}{: Converts an object of class \code{MTP} to an object of class \code{list}, with an entry for each slot.}
 
   \item{plot}{: plot methods for \code{MTP} class, produces the following graphical summaries of the results of a MTP. The type of display may be specified via the \code{which} argument. \cr

1. Scatterplot of number of rejected hypotheses vs. nominal Type I error rate. \cr

2. Plot of ordered adjusted p-values; can be viewed as a plot of Type I error rate vs. number of rejected hypotheses. \cr

3. Scatterplot of adjusted p-values vs. test statistics (also known as "volcano plot"). \cr

4. Plot of unordered adjusted p-values. \cr

5. Plot of confidence regions for user-specified parameters, by default the 10 parameters corresponding to the smallest adjusted p-values  (argument \code{top}). \cr

6. Plot of test statistics and corresponding cut-offs (for each value of \code{alpha}) for user-specified hypotheses, by default the 10 hypotheses corresponding to the smallest adjusted p-values (argument \code{top}). \cr

The argument \code{logscale} (by default equal to FALSE) allows one to use the negative decimal logarithms of the adjusted p-values in the second, third, and fourth graphical displays. The arguments \code{caption} and \code{sub.caption} allow one to change the titles and subtitles for each of the plots (default subtitle is the MTP function call). Note that some of these plots are implemented in the older function \code{mt.plot}.}

    \item{print}{: print method for \code{MTP} class, returns a description of an object of class \code{MTP}, including sample size, number of tested hypotheses, type of test performed (value of argument \code{test}), Type I error rate (value of argument \code{typeone}), nominal level of the test  (value of argument \code{alpha}), name of the MTP  (value of argument \code{method}), call to the function \code{MTP}.

In addition, this method produces a table with the class, mode, length, and dimension of each slot of the \code{MTP} instance. 
}

    \item{summary}{: summary method for \code{MTP} class, provides numerical summaries of the results of a MTP and returns a list with the following three components. \cr

1. rejections: A data.frame with the number(s) of rejected hypotheses for the nominal Type I error rate(s) specified by the \code{alpha} argument of the function \code{MTP}. (NULL values are returned if all three arguments \code{get.cr}, \code{get.cutoff}, and \code{get.adjp} are FALSE). \cr

2. index: A numeric vector of indices for ordering the hypotheses according to first \code{adjp}, then \code{rawp}, and finally the absolute value of \code{statistic} (not printed in the summary). \cr 

3. summaries: When applicable (i.e., when the corresponding quantities are returned by \code{MTP}), a table with six number summaries of the distributions of the adjusted p-values, unadjusted p-values, test statistics, and parameter estimates.}
}
    \item{update}{: update method for \code{MTP} class, provides a mechanism to re-run the MTP with different choices of the following arguments - alternative, typeone, k, q, fdr.method, alpha, smooth.null, method, get.cr, get.cutoff, get.adjp, keep.nulldist. When evaluate is 'TRUE', a new object of class MTP is returned. Else, the updated call is returned. The \code{MTP} object passed to the update method must have a non-empty nulldist slot (ie: must have been called with 'keep.nulldist=TRUE').
} 
}

\references{
M.J. van der Laan, S. Dudoit, K.S. Pollard (2004), Augmentation Procedures for Control of the Generalized Family-Wise Error Rate and Tail Probabilities for the Proportion of False Positives, Statistical Applications in Genetics and Molecular Biology, 3(1). 
\url{http://www.bepress.com/sagmb/vol3/iss1/art15/}

M.J. van der Laan, S. Dudoit, K.S. Pollard (2004), Multiple Testing. Part II. Step-Down Procedures for Control of the Family-Wise Error Rate, Statistical Applications in Genetics and Molecular Biology, 3(1).
\url{http://www.bepress.com/sagmb/vol3/iss1/art14/}

S. Dudoit, M.J. van der Laan, K.S. Pollard (2004), Multiple Testing. Part I. Single-Step Procedures for Control of General Type I Error Rates, Statistical Applications in Genetics and Molecular Biology, 3(1).
\url{http://www.bepress.com/sagmb/vol3/iss1/art13/}

Katherine S. Pollard and Mark J. van der Laan, "Resampling-based Multiple Testing: Asymptotic Control of Type I Error and Applications to Gene Expression Data" (June 24, 2003). U.C. Berkeley Division of Biostatistics Working Paper Series. Working Paper 121.
\url{http://www.bepress.com/ucbbiostat/paper121}
}

\author{Katherine S. Pollard, \url{http://lowelab.ucsc.edu/katie/} \cr
with design contributions from Sandrine Dudoit and Mark J. van der Laan.}

\seealso{\code{\link{MTP}}, \code{\link{MTP-methods}}, \code{\link{[-methods}}, \code{\link{as.list-methods}}, \code{\link{print-methods}}, \code{\link{plot-methods}}, \code{\link{summary-methods}}}

\examples{
## See MTP function: ? MTP
}

\keyword{classes}


