% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grid-pipeline.R
\name{add_preprocess}
\alias{add_preprocess}
\title{Add arbitrary preprocessing code to a multiverse analysis pipeline}
\usage{
add_preprocess(.df, process_name, code)
}
\arguments{
\item{.df}{The original \code{data.frame}(e.g., base data set). If part of
set of add_* decision functions in a pipeline, the base data will be passed
along as an attribute.}

\item{process_name}{a character string. A descriptive name for what the
preprocessing step accomplishes.}

\item{code}{the literal code you would like to execute after data are
filtered. \code{\link[glue]{glue}} syntax is allowed. An example might be
centering or scaling a predictor after the appropriate filters are applied
to the data.

The code should be written to work with pipes (i.e., \code{|>} or
\code{\%>\%}). Pre-processing code will eventually take the base data along
with any filters applied to the data. This means
\code{\link[dplyr]{mutate}} calls are the most natural but other functions
that take a \code{data.frame} as the first argument should work as well (as
long as they also return a \code{data.frame}).}
}
\value{
a \code{data.frame} with three columns: type, group, and code. Type
indicates the decision type, group is a decision, and the code is the
actual code that will be executed. If part of a pipe, the current set of
decisions will be appended as new rows.
}
\description{
Add arbitrary preprocessing code to a multiverse analysis pipeline
}
\examples{

library(tidyverse)
library(multitool)

the_data <-
  data.frame(
    id   = 1:500,
    iv1  = rnorm(500),
    iv2  = rnorm(500),
    iv3  = rnorm(500),
    mod1 = rnorm(500),
    mod2 = rnorm(500),
    mod3 = rnorm(500),
    cov1 = rnorm(500),
    cov2 = rnorm(500),
    dv1  = rnorm(500),
    dv2  = rnorm(500),
    include1 = rbinom(500, size = 1, prob = .1),
    include2 = sample(1:3, size = 500, replace = TRUE),
    include3 = rnorm(500)
  )

the_data |>
  add_filters(include1 == 0,include2 != 3,include2 != 2, include3 > -2.5) |>
  add_variables("ivs", iv1, iv2, iv3) |>
  add_variables("dvs", dv1, dv2) |>
  add_variables("mods", starts_with("mod")) |>
  add_preprocess("scale_iv", 'mutate({ivs} = scale({ivs}))')
}
