% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bf_equality.R
\name{bf_equality}
\alias{bf_equality}
\title{Bayes Factor with Inequality and (Approximate) Equality Constraints}
\usage{
bf_equality(
  k,
  options,
  A,
  b,
  C,
  d,
  prior = rep(1, sum(options)),
  M1 = 1e+05,
  M2 = 20000,
  delta = 0.5^(1:8),
  return_Ab = FALSE,
  ...
)
}
\arguments{
\item{k}{the number of choices for each alternative ordered by item type (e.g.
\code{c(a1,a2,a3,  b1,b2)} for a ternary and a binary item type).
The length of \code{k} must be equal to the sum of \code{options}.
The default \code{k=0} is equivalent to sampling from the prior.}

\item{options}{number of observable categories/probabilities for each item
type/multinomial distribution, e.g., \code{c(3,2)} for a ternary and binary item.}

\item{A}{a matrix with one row for each linear inequality constraint and one
column for each of the free parameters. The parameter space is defined
as all probabilities \code{x} that fulfill the order constraints  \code{A*x <= b}.}

\item{b}{a vector of the same length as the number of rows of \code{A}.}

\item{C}{a matrix specifying the equality constraints \code{C*x = d} with
columns refering to the free parameters (similar to \code{A})}

\item{d}{a vector with the same number of elements as the rows of \code{C}.}

\item{prior}{the prior parameters of the Dirichlet-shape parameters.
Must have the same length as \code{k}.}

\item{M1}{number of independent samples from the encompassing model to test
whether \code{A*x < b}.}

\item{M2}{number of Gibbs-sampling iterations for each step of the approximation
of \code{C*x = d}.}

\item{delta}{a vector of stepsizes that are used for the approximation.}

\item{return_Ab}{if \code{TRUE}, the function returns a list with the additional
inequality constraints (specified via \code{A}, \code{b}, and \code{steps})
that are used in the stepwise approximation \code{abs(C*x - d) < delta[i]}.}

\item{...}{further arguments passed to \code{\link{count_binom}} or
\code{\link{count_multinom}} (e.g., \code{M}, \code{steps}).}
}
\description{
To obtain the Bayes factor for the equality constraints \code{C*x = d}, a
sequence of approximations \code{abs(C*x - d) < delta} is used.
}
\details{
First, the encompassing Bayes factor for the equality constraint \code{A*x<b}
is computed using \code{M1} independent Dirichlet samples. Next, the equality
constraint \code{C*x=d} is approximated by drawing samples from the model
\code{A*x<b} and testing whether \code{abs(C*x - d) < delta[1]}. Similarly, the
stepsize \code{delta} is reduced step by step until \code{abs(C*x - d) < min(delta)}.
Klugkist  et al. (2010) show that this procedure provides a valid approximation
of the exact equality constraints if the step size becomes sufficiently small.
}
\examples{
# Equality constraints:  C * x = d
d <- c(.5, .5, 0)
C <- matrix(
  c(
    1, 0, 0, 0, # p1 = .50
    0, 1, 0, 0, # p2 = .50
    0, 0, 1, -1
  ), # p3 = p4
  ncol = 4, byrow = TRUE
)
k <- c(3, 7, 6, 4, 2, 8, 5, 5)
options <- c(2, 2, 2, 2)
bf_equality(k, options,
  C = C, d = d, delta = .5^(1:5),
  M1 = 50000, M2 = 5000
) # only for CRAN checks

# check against exact equality constraints (see ?bf_binom)
k_binom <- k[seq(1, 7, 2)]
bf_binom(k_binom,
  n = 10, A = matrix(0), b = 0,
  map = c(0, 0, 1, 1)
)
}
\references{
Klugkist, I., Laudy, O., & Hoijtink, H. (2010). Bayesian evaluation of inequality and equality constrained hypotheses for contingency tables. Psychological Methods, 15(3), 281-299. \doi{10.1037/a0020137}
}
