% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sort_inequalities.R
\name{Ab_sort}
\alias{Ab_sort}
\title{Sort Inequalities by Acceptance Rate}
\usage{
Ab_sort(A, b, k = 0, options, M = 1000, drop_irrelevant = TRUE)
}
\arguments{
\item{A}{a matrix with one row for each linear inequality constraint and one
column for each of the free parameters. The parameter space is defined
as all probabilities \code{x} that fulfill the order constraints  \code{A*x <= b}.}

\item{b}{a vector of the same length as the number of rows of \code{A}.}

\item{k}{optional: number of observed frequencies (only for posterior sampling).}

\item{options}{optional: number of options per item type/category system.
Uniform sampling on [0,1] for each parameter is used if omitted.}

\item{M}{number of samples.}

\item{drop_irrelevant}{whether to drop irrelevant constraints for probabilities such as
\code{theta[1] >= 0}, \code{theta[1] <= 1}, or \code{sum(theta) <= 1}.}
}
\description{
Uses samples from the prior/posterior to order the inequalities by the acceptance rate.
}
\details{
Those constraints that are rejected most often are placed at the first positions.
This can help when computing the encompassing Bayes factor and counting how many samples
satisfy the constraints (e.g., \code{\link{count_binom}} or \code{\link{bf_multinom}}).
Essentially, it becomes more likely that the while-loop for testing
whether the inequalities hold can stop earlier, thus making the computation faster.

The function could also be helpful to improve the efficiency of the stepwise
sampling implemented in \code{\link{count_binom}} and \code{\link{count_multinom}}.
First, one can use accept-reject sampling to test the first few, rejected
inequalities. Next, one can use a Gibbs sampler to draw samples conditional on the
first constraints.
}
\examples{
### Binomial probabilities
b <- c(0,0,.30,.70, 1)
A <- matrix(c(-1,1,0,  # p1 >= p2
              0,1,-1,  # p2 <= p3
              1,0,0,   # p1 <=.30
              0,1,0,   # p2 <= .70
              0,0,1),  # p3 <= 1 (redundant)
              ncol = 3, byrow = 2)
Ab_sort(A, b)


### Multinomial probabilities
# prior sampling:
Ab_sort(A, b, options = 4)
# posterior sampling:
Ab_sort(A, b, k = c(10,3, 2, 14), options = 4)

}
