% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stan_nma-class.R
\name{summary.stan_nma}
\alias{summary.stan_nma}
\alias{plot.stan_nma}
\title{Posterior summaries from \code{stan_nma} objects}
\usage{
\method{summary}{stan_nma}(object, ..., pars, include, probs = c(0.025, 0.25, 0.5, 0.75, 0.975))

\method{plot}{stan_nma}(
  x,
  ...,
  pars,
  include,
  stat = "pointinterval",
  orientation = c("horizontal", "vertical", "y", "x"),
  ref_line = NA_real_
)
}
\arguments{
\item{...}{Additional arguments passed on to other methods}

\item{pars, include}{See \code{\link[rstan:stanfit-method-extract]{rstan::extract()}}}

\item{probs}{Numeric vector of specifying quantiles of interest, default
\code{c(0.025, 0.25, 0.5, 0.75, 0.975)}}

\item{x, object}{A \code{stan_nma} object}

\item{stat}{Character string specifying the \code{ggdist} plot stat to use,
default \code{"pointinterval"}}

\item{orientation}{Whether the \code{ggdist} geom is drawn horizontally
(\code{"horizontal"}) or vertically (\code{"vertical"}), default \code{"horizontal"}}

\item{ref_line}{Numeric vector of positions for reference lines, by default
no reference lines are drawn}

\item{summary}{Logical, calculate posterior summaries? Default \code{TRUE}.}
}
\value{
A \link{nma_summary} object
}
\description{
Posterior summaries of model parameters in \code{stan_nma} objects may be produced
using the \code{summary()} method and plotted with the \code{plot()} method. NOTE: To
produce relative effects, absolute predictions, or posterior ranks, see
\code{\link[=relative_effects]{relative_effects()}}, \code{\link[=predict.stan_nma]{predict.stan_nma()}}, \code{\link[=posterior_ranks]{posterior_ranks()}},
\code{\link[=posterior_rank_probs]{posterior_rank_probs()}}.
}
\details{
The \code{plot()} method is a shortcut for \code{plot(summary(stan_nma))}. For
details of plotting options, see \code{\link[=plot.nma_summary]{plot.nma_summary()}}.
}
\examples{
## Smoking cessation
\donttest{
# Run smoking RE NMA example if not already available
if (!exists("smk_fit_RE")) example("example_smk_re", run.donttest = TRUE)
}
\donttest{
# Summary and plot of all model parameters
summary(smk_fit_RE)
plot(smk_fit_RE)

# Summary and plot of heterogeneity tau only
summary(smk_fit_RE, pars = "tau")
plot(smk_fit_RE, pars = "tau")

# Customising plot output
plot(smk_fit_RE,
     pars = c("d", "tau"),
     stat = "halfeye",
     ref_line = 0)
}
}
\seealso{
\code{\link[=plot.nma_summary]{plot.nma_summary()}}, \code{\link[=relative_effects]{relative_effects()}}, \code{\link[=predict.stan_nma]{predict.stan_nma()}},
\code{\link[=posterior_ranks]{posterior_ranks()}}, \code{\link[=posterior_rank_probs]{posterior_rank_probs()}}
}
