% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/relative_effects.R
\name{relative_effects}
\alias{relative_effects}
\title{Relative treatment effects}
\usage{
relative_effects(
  x,
  newdata = NULL,
  study = NULL,
  all_contrasts = FALSE,
  trt_ref = NULL,
  probs = c(0.025, 0.25, 0.5, 0.75, 0.975),
  predictive_distribution = FALSE,
  summary = TRUE
)
}
\arguments{
\item{x}{A \code{stan_nma} object created by \code{\link[=nma]{nma()}}}

\item{newdata}{Only used if a regression model is fitted. A data frame of
study details, one row per study, giving the covariate values at which to
produce relative effects. Column names must match variables in the
regression model. If \code{NULL}, relative effects are produced for all studies
in the network.}

\item{study}{Column of \code{newdata} which specifies study names, otherwise
studies will be labelled by row number.}

\item{all_contrasts}{Logical, generate estimates for all contrasts (\code{TRUE}),
or just the "basic" contrasts against the network reference treatment
(\code{FALSE})? Default \code{FALSE}.}

\item{trt_ref}{Reference treatment to construct relative effects against, if
\code{all_contrasts = FALSE}. By default, relative effects will be against the
network reference treatment. Coerced to character string.}

\item{probs}{Numeric vector of quantiles of interest to present in computed
summary, default \code{c(0.025, 0.25, 0.5, 0.75, 0.975)}}

\item{predictive_distribution}{Logical, when a random effects model has been
fitted, should the predictive distribution for relative effects in a new
study be returned? Default \code{FALSE}.}

\item{summary}{Logical, calculate posterior summaries? Default \code{TRUE}.}
}
\value{
A \link{nma_summary} object if \code{summary = TRUE}, otherwise a list
containing a 3D MCMC array of samples and (for regression models) a data
frame of study information.
}
\description{
Generate (population-average) relative treatment effects. If a ML-NMR or
meta-regression model was fitted, these are specific to each study
population.
}
\examples{
## Smoking cessation
\donttest{
# Run smoking RE NMA example if not already available
if (!exists("smk_fit_RE")) example("example_smk_re", run.donttest = TRUE)
}
\donttest{
# Produce relative effects
smk_releff_RE <- relative_effects(smk_fit_RE)
smk_releff_RE
plot(smk_releff_RE, ref_line = 0)

# Relative effects for all pairwise comparisons
relative_effects(smk_fit_RE, all_contrasts = TRUE)

# Relative effects against a different reference treatment
relative_effects(smk_fit_RE, trt_ref = "Self-help")

# Transforming to odds ratios
# We work with the array of relative effects samples
LOR_array <- as.array(smk_releff_RE)
OR_array <- exp(LOR_array)

# mcmc_array objects can be summarised to produce a nma_summary object
smk_OR_RE <- summary(OR_array)

# This can then be printed or plotted
smk_OR_RE
plot(smk_OR_RE, ref_line = 1)
}

## Plaque psoriasis ML-NMR
\donttest{
# Run plaque psoriasis ML-NMR example if not already available
if (!exists("pso_fit")) example("example_pso_mlnmr", run.donttest = TRUE)
}
\donttest{
# Produce population-adjusted relative effects for all study populations in
# the network
pso_releff <- relative_effects(pso_fit)
pso_releff
plot(pso_releff, ref_line = 0)

# Produce population-adjusted relative effects for a different target
# population
new_agd_means <- data.frame(
  bsa = 0.6,
  prevsys = 0.1,
  psa = 0.2,
  weight = 10,
  durnpso = 3)

relative_effects(pso_fit, newdata = new_agd_means)
}
}
\seealso{
\code{\link[=plot.nma_summary]{plot.nma_summary()}} for plotting the relative effects.
}
