\name{train_one_vs_rest_TSP}
\alias{train_one_vs_rest_TSP}
\title{
Build multiclass rule-based classifier as one-vs-rest scheme}
\description{
\code{train_one_vs_rest_TSP} trains multiclass classifier in a one-vs-rest scheme by combining binary classifiers for each class produced by switchBox package.
}
\usage{
train_one_vs_rest_TSP(data_object,
                      filtered_genes,
                      k_range = 2:50,
                      include_pivot = FALSE,
                      one_vs_one_scores = FALSE,
                      platform_wise_scores = FALSE,
                      disjoint = TRUE,
                      seed = NULL,
                      classes,
                      SB_arg = list(),
                      verbose = TRUE)
}

\arguments{
  \item{data_object}{
data object generated by ReadData function. Object contains the data and labels.
}
  \item{filtered_genes}{
filtered genes object produced by filter_genes_TSP function}
  \item{k_range}{
an integer or range represent the candidate number of Top Scoring Pairs (TSPs) in the individual (i.e. binary) classifiers. Default range from 2 to 50.
}
  \item{include_pivot}{
a logical indicating if the filtered genes should also be paired with all features available in the data matrix. Default is FALSE. include_pivot=FALSE means filtered genes will be paired with themselves only.}
  \item{one_vs_one_scores}{
logical indicating if rules scores for each class should be calculated as a mean of one-vs-one scores instead of one-vs-rest manner. Default is FALSE.
}
  \item{platform_wise_scores}{
logical indicating if rules scores for each class should be calculated in each platform-wise then averaged instead of merging all platforms together. Default is FALSE.
}
  \item{disjoint}{
is a logical value indicating whether only disjoint pairs should be considered in the final set of selected pairs; i.e. all features occur only once among the set of TSPs. This is an argument to be passed to the training function \code{SWAP.Train.KTSP} from \pkg{switchBox} package.}
  \item{seed}{
an integer to set a seed for the training process (for reproducibility).
}
  \item{classes}{
optional vector contains the names of classes in the wanted order.
This means the individual classifiers will be ordered based on this vector. If this vector does not have all class names, then no classifiers will be train for those classes that are not mentioned and the samples from these classes will be removed from the training dataset.
}
  \item{SB_arg}{
list of any additional arguments to be passed to the training function \code{SWAP.Train.KTSP} from \pkg{switchBox} package
  }
   \item{verbose}{
a logical value indicating whether processing messages will be printed or not. Default is TRUE.
}

}
\details{
This function uses \code{SWAP.Train.KTSP} function from \pkg{switchBox} where the algorithm (Afsari et al (AOAS, 2014)) chooses the optimal number of rules (i.e. pairs) among the input range.}
\value{
Returns \code{OnevsrestScheme_TSP} object which contains one-vs-rest classifiers for the classes. These individual classifiers are top score pairs classifiers.
}

\author{
Nour-al-dain Marzouka <nour-al-dain.marzouka at med.lu.se>
}

\examples{
# random data
Data <- matrix(runif(100000), nrow=100, ncol=100,
               dimnames = list(paste0("G",1:100), paste0("S",1:100)))

# labels
L <- sample(x = c("A","B","C"), size = 100, replace = TRUE)

# study/platform
P <- sample(c("P1","P2"), size = 100, replace = TRUE)

object <- ReadData(Data = Data,
             Labels = L,
                   Platform = P)

# switchBox package from Bioconductor is needed
# Visit their website or install switchBox package using:
# if(!requireNamespace("switchBox", quietly = TRUE)){
#       if (!requireNamespace('BiocManager', quietly = TRUE)) {
#       install.packages('BiocManager')
#      }
#      BiocManager::install('switchBox')", call. = FALSE)
#  }

filtered_genes <- filter_genes_TSP(data_object = object,
                                  filter = "one_vs_rest",
                                  platform_wise = FALSE,
                                  featureNo = 10,
                                  UpDown = TRUE,
                                  verbose = FALSE)

# training
# classifier <- train_one_vs_rest_TSP(data_object = object,
#                              filtered_genes = filtered_genes,
#                              k_range = 2:50,
#                              include_pivot = FALSE,
#                              one_vs_one_scores = FALSE,
#                              platform_wise_scores = FALSE,
#                              seed = 1234,
#                              verbose = FALSE)

# results <- predict_one_vs_rest_TSP(classifier = classifier,
#                                   Data = object,
#                                   tolerate_missed_genes = TRUE,
#                                   weighted_votes = TRUE,
#                                   verbose = FALSE)

# Confusion Matrix and Statistics on training data
#  caret::confusionMatrix(data = factor(results$max_score, levels = unique(L)),
#                         reference = factor(L, levels = unique(L)),
#                         mode="everything")

# not to run
# plot_binary_TSP(Data = object, classes=c("A","B","C"),
#                 classifier = classifier,
#                 prediction = results,
#                 title = "Test")
}
