% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unsupervised.R
\name{mcoa}
\alias{mcoa}
\title{Multiple Co-Inertia Analysis - MCOA}
\usage{
mcoa(X, ncomp = 2, scale = FALSE, verbose = FALSE, ...)
}
\arguments{
\item{X}{\code{list} of input blocks.}

\item{ncomp}{\code{integer} number of components to extract.}

\item{scale}{\code{logical} indicating if variables should be scaled.}

\item{verbose}{\code{logical} indicating if diagnostic information should be printed.}

\item{...}{additional arguments for RGCCA.}
}
\value{
\code{multiblock} object including relevant scores and loadings. Relevant plotting functions: \code{\link{multiblock_plots}}
and result functions: \code{\link{multiblock_results}}.
}
\description{
This is a wrapper for the \code{RGCCA::rgcca} function for computing MCOA.
}
\details{
MCOA resembles GCA and MFA in that it creates a set of reference scores, for which each
block's individual scores should correlate maximally too, but also the variance within
each block should be taken into account. A single component solution is equivalent to a
PCA on concatenated blocks scaled by the so called inverse inertia.
}
\examples{
data(potato)
potList <- as.list(potato[c(1,2,9)])
pot.mcoa   <- mcoa(potList)
plot(scores(pot.mcoa), labels="names")

}
\references{
\itemize{
\item Le Roux; B. and H. Rouanet (2004). Geometric Data Analysis, From Correspondence Analysis to Structured Data Analysis. Dordrecht. Kluwer: p.180.
\item Greenacre, Michael and Blasius, Jörg (editors) (2006). Multiple Correspondence Analysis and Related Methods. London: Chapman & Hall/CRC.
}
}
\seealso{
Overviews of available methods, \code{\link{multiblock}}, and methods organised by main structure: \code{\link{basic}}, \code{\link{unsupervised}}, \code{\link{asca}}, \code{\link{supervised}} and \code{\link{complex}}.
Common functions for computation and extraction of results and plotting are found in \code{\link{multiblock_results}} and \code{\link{multiblock_plots}}, respectively.
}
