#' The mully package
#'
#' R package to create, modify and visualize graphs with multiple layers.
#'
#' @rdname mully-package
#' @name mully-package
#' @aliases mully-package
#' @docType package
#'
#' @section Introduction:
#'Network theory has been used for many years in the modeling and analysis of complex systems, as epidemiology, biology and biomedicine . As the data evolves and becomes more heterogeneous and complex, monoplex networks become an oversimplification of the corresponding systems. This imposes a need to go beyond traditional networks into a richer framework capable of hosting objects and relations of different scales, called Multilayered Network
#' **Mully**, **mul**ti**l**a**y**er networks, is an R package that provides a multilayer network framework.
#'Using this package, the user can create, modify and visualize graphs with multiple layers. This package is an extension to the [igraph package](https://github.com/igraph/rigraph) that provides a monolayer graph framework.
#'The package is implemented as a part of [the Multipath Project](https://www.sys-med.de/en/junior-research-groups/multipath/)  directed by [Dr. Frank Kramer](https://www.uni-augsburg.de/de/fakultaet/fai/informatik/prof/misit/mitarbeiter/) .
#'

#'
#' @section Creating graphs:
#'\link[mully]{mully},
#'\link[mully]{addLayer},
#'\link[mully]{addNode},
#'\link[mully]{addEdge},
#'\link[mully]{removeLayer},
#'\link[mully]{removeNode},
#'\link[mully]{removeEdge},
#'\link[mully]{getNodeAttributes},
#'\link[mully]{getEdgeAttributes}
#'
#' @section Visualization:
#'\link[mully]{plot.mully},
#'\link[mully]{plot3d}
#'
#' @section Further information:
#'More information and references can be found in the mully paper:
#'
#'https://www.mdpi.com/2073-4425/9/11/519

NULL
