% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mudata.R
\name{new_mudata}
\alias{new_mudata}
\alias{validate_mudata}
\title{Validate, create a mudata object}
\usage{
new_mudata(md, x_columns)

validate_mudata(
  md,
  check_unique = TRUE,
  check_references = TRUE,
  action = abort
)
}
\arguments{
\item{md}{An object of class 'mudata'}

\item{x_columns}{The x_columns attribute (see \link{mudata}).}

\item{check_unique}{Check if columns identify unique values in the appropriate tables}

\item{check_references}{Check the referential integrity of the mudata object}

\item{action}{The function to be called when errors are detected in validate_mudata}
}
\description{
Validates a mudata object by calling \link[rlang:abort]{rlang::abort} when an error is found;
creates a mudata object from a \link{list}. Validation is generally performed
when objects are created using \link{mudata}, or when objects are read/writen
using \link{read_mudata} and \link{write_mudata}.
}
\examples{
validate_mudata(kentvillegreenwood)
new_mudata(kentvillegreenwood, x_columns = "date")

}
