% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mudata_subset.R
\name{filter_datasets}
\alias{filter_datasets}
\alias{filter_datasets.default}
\alias{filter_data}
\alias{filter_data.default}
\alias{filter_locations}
\alias{filter_locations.default}
\alias{filter_params}
\alias{filter_params.default}
\title{Subset a mudata object by complex expression}
\usage{
filter_datasets(.data, ...)

\method{filter_datasets}{default}(.data, ...)

filter_data(.data, ...)

\method{filter_data}{default}(.data, ...)

filter_locations(.data, ...)

\method{filter_locations}{default}(.data, ...)

filter_params(.data, ...)

\method{filter_params}{default}(.data, ...)
}
\arguments{
\item{.data}{A \link{mudata} object}

\item{...}{Objects passed to \link[dplyr:filter]{filter} on the appropriate table}
}
\value{
A subsetted mudata object
}
\description{
These methods allow more complex selection criteria than \link{select_datasets} and
family, which only use the identifier values. These methods first subset
the required table using the provided expression, then subset other tables
to ensure internal consistency.
}
\examples{
# select only locations with a latitude above 45
ns_climate \%>\%
  filter_locations(latitude > 45)

# select only params measured in mm
ns_climate \%>\%
  filter_params(unit == "mm")

# select only june temperature from ns_climate
library(lubridate)
ns_climate \%>\%
  filter_data(month(date) == 6)

}
\seealso{
\link[dplyr:filter]{filter}, \link{select_locations}
}
