% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mudata_subset.R
\name{subset.mudata}
\alias{subset.mudata}
\title{Subset a MuData object}
\usage{
\method{subset}{mudata}(x, ..., datasets = NULL, params = NULL,
  locations = NULL)
}
\arguments{
\item{x}{The object to subset}

\item{...}{Used to \link[dplyr:filter]{filter} the data table}

\item{datasets}{Vector of datasets to include}

\item{params}{Vector of parameters to include}

\item{locations}{Vector of locations to include}
}
\value{
A subsetted mudata object
}
\description{
This object uses standard evalutation to subset a \link{mudata} object using
character vectors of datasets, params, and locations. The result is subsetted such
that all rows in the data table are documented in the other tables (provided)
they were to begin with. It is preferred to use \link{select_locations},
\link{select_params}, and \link{select_datasets} to subset a mudata object,
or \link{filter_data}, \link{filter_locations}, \link{filter_params},
and \link{filter_datasets} to subset by row while maintaining internal
consistency.
}
\examples{
subset(kentvillegreenwood, params = c("mintemp", "maxtemp"))

}
\seealso{
\link{select_locations}, \link{select_params}, \link{select_datasets}, \link{filter_data},
\link{filter_locations}, \link{filter_params}, and \link{filter_datasets}
}
