% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chart_data_styles.R
\name{chart_data_line_style}
\alias{chart_data_line_style}
\title{Modify line style}
\usage{
chart_data_line_style(x, values)
}
\arguments{
\item{x}{an \code{ms_chart} object.}

\item{values}{\verb{character(num of series)}: a set of line style values to map data values to.
It is a named vector, the values will be matched based on the names.
Possible values are: 'none', 'solid', 'dashed', 'dotted'.
If it contains only one line style, this style will be associated to all existing series.}
}
\description{
Specify mappings from levels in the data to displayed line style.
}
\examples{
my_scatter <- ms_scatterchart(data = iris, x = "Sepal.Length",
  y = "Sepal.Width",  group = "Species")
my_scatter <- chart_data_fill(my_scatter,
  values = c(virginica = "#6FA2FF", versicolor = "#FF6161", setosa = "#81FF5B") )
my_scatter <- chart_data_stroke(my_scatter,
  values = c(virginica = "black", versicolor = "black", setosa = "black") )
my_scatter <- chart_data_symbol(my_scatter,
  values = c(virginica = "circle", versicolor = "diamond", setosa = "circle") )
my_scatter <- chart_data_line_style(my_scatter,
  values = c(virginica = "solid", versicolor = "dotted", setosa = "dashed") )
}
\seealso{
Other Series customization functions: 
\code{\link{chart_data_fill}()},
\code{\link{chart_data_line_width}()},
\code{\link{chart_data_size}()},
\code{\link{chart_data_smooth}()},
\code{\link{chart_data_stroke}()},
\code{\link{chart_data_symbol}()},
\code{\link{chart_labels_text}()}
}
\concept{Series customization functions}
