% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chart_data_color.R
\name{chart_data_line_width}
\alias{chart_data_line_width}
\title{Modify line width}
\usage{
chart_data_line_width(x, values)
}
\arguments{
\item{x}{an \code{ms_chart} object.}

\item{values}{\verb{double(num of series)}: a set of size values to map data values to.
It is a named vector, the values will be matched based on the names.
If it contains only one size, this size will be associated to all existing series.}
}
\description{
Specify mappings from levels in the data to displayed line width between symbols.
}
\examples{
my_scatter <- ms_scatterchart(data = iris, x = "Sepal.Length",
  y = "Sepal.Width",  group = "Species")
my_scatter <- chart_settings(my_scatter, scatterstyle = "lineMarker")
my_scatter <- chart_data_fill(my_scatter,
  values = c(virginica = "#6FA2FF", versicolor = "#FF6161", setosa = "#81FF5B") )
my_scatter <- chart_data_stroke(my_scatter,
  values = c(virginica = "black", versicolor = "black", setosa = "black") )
my_scatter <- chart_data_symbol(my_scatter,
  values = c(virginica = "circle", versicolor = "diamond", setosa = "circle") )
my_scatter <- chart_data_size(my_scatter,
  values = c(virginica = 20, versicolor = 16, setosa = 20) )
my_scatter <- chart_data_line_width(my_scatter,
  values = c(virginica = 2, versicolor = 3, setosa = 6) )
}
\seealso{
\code{\link{chart_data_fill}}, \code{\link{chart_data_stroke}}, \code{\link{chart_data_symbol}}
}
