% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mrbin.R
\name{editmrbin}
\alias{editmrbin}
\title{A function for editing mrbin objects.}
\usage{
editmrbin(
  mrbinObject,
  functionName = "mrbin::editmrbin",
  versionNumber = as.character(utils::packageVersion("mrbin")),
  bins = NULL,
  parameters = NULL,
  metadata = NULL,
  transformations = NULL,
  comment = "",
  verbose = TRUE
)
}
\arguments{
\item{mrbinObject}{An mrbin object}

\item{functionName}{Name of the package and function calling this command}

\item{versionNumber}{Version number of the package calling this command}

\item{bins}{A matrix containing values to be written to the mrbin object}

\item{parameters}{A list containing values to be written to the mrbin object parameters, names must be names of the mrbin object, e.g. dimension}

\item{metadata}{A list containing values to be written to the mrbin object parameters, names must be names of the mrbin object}

\item{transformations}{An optional character vector describing any used data transformations or scaling such as reference scaling, PQN, log, atnv, etc.}

\item{comment}{An optional character vector describing the change}

\item{verbose}{Should a summary be displayed?}
}
\value{
An (invisible) mrbin object
}
\description{
This function edits an mrbin object and returns it. This is the only documented way to edit mrbin objects, all other ways of editing such object might cause warning message
}
\examples{
mrbinObject<-createmrbin()
mrbinObject<-editmrbin(mrbinObject)
}
