% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bglmnet.R
\name{bglmnet}
\alias{bglmnet}
\title{Model stability and variable importance plots for glmnet}
\usage{
bglmnet(mf, nlambda = 100, lambda = NULL, B = 100, penalty.factor,
  screen = FALSE, n.cores = NULL, force.in = NULL)
}
\arguments{
\item{mf}{a fitted 'full' model, the result of a call
to lm or glm.}

\item{nlambda}{how many penalty values to consider.  Default = 100.}

\item{lambda}{manually specify the penalty values (optional).}

\item{B}{number of bootstrap replications}

\item{penalty.factor}{Separate penalty factors can be applied to each
coefficient. This is a number that multiplies lambda to allow
differential shrinkage. Can be 0 for some variables, which implies
no shrinkage, and that variable is always included in the model.
Default is 1 for all variables (and implicitly infinity for variables
listed in exclude). Note: the penalty factors are internally rescaled
to sum to nvars, and the lambda sequence will reflect this change.}

\item{screen}{logical, whether or not to perform an initial
screen for outliers.  Highly experimental, use at own risk.
Default = FALSE.}

\item{n.cores}{number of cores to be used when parallel
processing the bootstrap (Not yet implemented.)}

\item{force.in}{the names of variables that should be forced
into all estimated models. (Not yet implemented.)}

\item{...}{further arguments (currently unused)}
}
\description{
Model stability and variable importance plots for glmnet
}
\details{
The result of this function is essentially just a
  list. The supplied plot method provides a way to visualise the
  results.
}
\seealso{
\code{\link{plot.bglmnet}}
}

