% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/af.R
\name{plot.af}
\alias{plot.af}
\title{Plot diagnostics for an af object}
\usage{
\method{plot}{af}(x, pch, classic = FALSE, tag = NULL, best.only = TRUE,
  width = 800, height = 400, fontSize = 12, left = 50, top = 30,
  chartWidth = "60\%", chartHeight = "80\%",
  backgroundColor = "transparent", legend.position = "topleft",
  options = NULL, ...)
}
\arguments{
\item{x}{\code{af} object, the result of \code{\link{af}}}

\item{pch}{plotting character, i.e., symbol to use}

\item{classic}{logical.  If \code{classic=TRUE} a
base graphics plot is provided instead of a googleVis plot.
Default is \code{classic=FALSE}.}

\item{tag}{Default NULL. Name tag of the objects to be extracted
from a gvis (googleVis) object.

The default tag for is NULL, which will
result in R opening a browser window.  Setting \code{tag='chart'}
or setting \code{options(gvis.plot.tag='chart')} is useful when
googleVis is used in scripts, like knitr or rmarkdown.}

\item{best.only}{logical determining whether the output used the
standard fence approach of only considering the best models
that pass the fence (\code{TRUE}) or if it should take into
account all models that pass the fence at each boundary
value (\code{FALSE}).}

\item{width}{Width of the googleVis chart canvas area, in pixels.
Default: 800.}

\item{height}{Height of the googleVis chart canvas area, in pixels.
Default: 400.}

\item{fontSize}{font size used in googleVis chart.  Default: 12.}

\item{left}{space at left of chart (pixels?).  Default: "50".}

\item{top}{space at top of chart (pixels?).  Default: "30".}

\item{chartWidth}{googleVis chart area width.
A simple number is a value in pixels;
a string containing a number followed by \code{\%} is a percentage.
Default: \code{"60\%"}}

\item{chartHeight}{googleVis chart area height.
A simple number is a value in pixels;
a string containing a number followed by \code{\%} is a percentage.
Default: \code{"80\%"}}

\item{backgroundColor}{The background colour for the main area
of the chart. A simple HTML color string,
for example: 'red' or '#00cc00'.  Default: 'transparent'}

\item{legend.position}{legend position, e.g. \code{"topleft"}
or  \code{"bottomright"}}

\item{options}{If you want to specify the full set of googleVis
options.}

\item{...}{further arguments (currently unused)}
}
\description{
Summary plot of the bootstrap results of an
af object.
}

