% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graphics_related.R
\name{PIT_ggPlot}
\alias{PIT_ggPlot}
\alias{gg_histcompPIT}
\alias{gg_qqcompPIT}
\title{ggplot version of PIT Plots for a CMP Object}
\usage{
gg_histcompPIT(
  object,
  bins = 10,
  ref_line = TRUE,
  col_line = "red",
  col_hist = "royal blue",
  size = 1
)

gg_qqcompPIT(
  object,
  bins = 10,
  col1 = "red",
  col2 = "#999999",
  lty1 = 1,
  lty2 = 2
)
}
\arguments{
\item{object}{an object class "cmp", obtained from a call to \code{glm.cmp}.}

\item{bins}{numeric; the number of bins shown in the PIT histogram or the
PIT Q-Q plot.}

\item{ref_line}{logical; if \code{TRUE} (default), the line for displaying the standard
uniform distribution will be shown for the purpose of comparison.}

\item{col_line}{numeric or character: the colour of the reference line
for comparison in PIT histogram.}

\item{col_hist}{numeric or character; the colour of the histogram for PIT.}

\item{size}{numeric; the line widths for the comparison line in PIT histogram.}

\item{col1}{numeric or character; the colour of the sample uniform Q-Q plot in PIT.}

\item{col2}{numeric or character; the colour of the theoretical uniform Q-Q plot in PIT.}

\item{lty1}{integer or character string: the line types for the sample
uniform Q-Q plot in PIT, see ggplot2::linetype.}

\item{lty2}{an integer or character string: the line types for the theoretical uniform
Q-Q plot in PIT, see ggplot2::linetype.}
}
\description{
Two plots for the non-randomized PIT are currently available for checking the
distributional assumption of the fitted CMP model: the PIT histogram, and
the uniform Q-Q plot for PIT.
}
\details{
\code{histcompPIT} and \code{qqcompPIT}

The histogram and the Q-Q plot are used to compare the fitted profile with a standard
uniform distribution. If they match relatively well, it means the CMP distribution
is appropriate for the data.

The \code{histcompPIT} and \code{qqcompPIT} functions
would provide the same two plots but in base R format.
}
\examples{
## For examples see example(gg_plot)
}
\references{
Czado, C., Gneiting, T. and Held, L. (2009). Predictive model assessment
for count data. \emph{Biometrics}, \strong{65}, 1254--1261.

Dunsmuir, W.T.M. and Scott, D.J. (2015). The \code{glarma} Package for Observation-Driven
Time Series Regression of Counts. \emph{Journal of Statistical Software},
\strong{67}, 1--36.
}
\seealso{
\code{\link{histcompPIT}}, \code{\link{qqcompPIT}},
\code{\link{plot.cmp}} and \code{\link{gg_plot}}.
}
