% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sensor_functions.R
\name{screen_duration}
\alias{screen_duration}
\title{Screen duration by hour or day}
\usage{
screen_duration(
  db,
  participant_id,
  start_date = NULL,
  end_date = NULL,
  by = c("Hour", "Day")
)
}
\arguments{
\item{db}{A database connection to an m-Path Sense database.}

\item{participant_id}{A character string identifying a single participant. Use
\code{\link[mpathsenser]{get_participants}} to retrieve all participants from the database.
Leave empty to get data for all participants.}

\item{start_date}{Optional search window specifying date where to begin search. Must be
convertible to date using \link[base]{as.Date}. Use \link[mpathsenser]{first_date} to find the
date of the first entry for a participant.}

\item{end_date}{Optional search window specifying date where to end search. Must be convertible
to date using \link[base]{as.Date}. Use \link[mpathsenser]{last_date} to find the date of the
last entry for a participant.}

\item{by}{Either 'Hour' or 'Day' indicating how to summarise the results. Leave empty to get raw
screen duration per measurement.}
}
\value{
A tibble with either 'hour' and 'duration' columns or 'date' and 'duration' columns
depending on the \code{by} argument. Alternatively, if no \code{by} is specified, a remote
tibble is returned with the date, time, and duration since the previous measurement.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

Calculate the screen duration time where the screen was \emph{unlocked} (i.e. not just on).
}
\keyword{internal}
