% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_scalebar.R
\name{add_scalebar}
\alias{add_scalebar}
\title{Add scalebar to frames}
\usage{
add_scalebar(frames, distance = NULL, height = 0.015,
  position = "bottomleft", x = NULL, y = NULL, colour = "black",
  label_margin = 1.2, units = "km", verbose = TRUE)
}
\arguments{
\item{frames}{list of \code{ggplot2} objects, crated with \code{\link{frames_spatial}}.}

\item{distance}{numeric, optional. Distance displayed by the scalebar (in either km or miles defined by argument \code{units}) By default, the displayed distance is calculated automatically.}

\item{height}{numeric, height of the scalebar in a range from 0 to 1 as the proportion of the overall height of the frame map. Default is 0.015.}

\item{position}{character, position of the scalebar on the map. Either \code{"bottomleft", "upperleft", "upperright", "bottomright"}. Ignored, if \code{x} and \code{y} are set.}

\item{x}{numeric, position of the bottom left corner of the scalebar on the x axis. If not set, \code{position} is used to calculate the position of the scalebar.}

\item{y}{numeric, position of the bottom left corner of the scalebar on the y axis. If not set, \code{position} is used to calculate the position of the scalebar.}

\item{colour}{character, colour of the distance labels. Default is \code{"black"}.}

\item{label_margin}{numeric, distance of the labels to the scalebar as a proportion of the height of the scalebar (e.g. if set to 2, the labels will be positioned with a distance to the scalebar of twice the scalebar height).}

\item{units}{character, either "km" for kilometers or "miles" for miles.}

\item{verbose}{logical, if \code{TRUE}, messages on the function's progress are displayed (default).}
}
\value{
List of frames.
}
\description{
This function adds a scalebar to the animation frames created with \code{\link{frames_spatial}}.
}
\examples{
library(moveVis)
library(move)

data("move_data", "basemap_data")
m <- align_move(move_data, res = 4, unit = "mins")

# create spatial frames using a custom NDVI base layer
r_list <- basemap_data[[1]]
r_times <- basemap_data[[2]]

\donttest{
frames <- frames_spatial(m, r_list = r_list, r_times = r_times, r_type = "gradient",
                         fade_raster = TRUE)

# add a scale bar to frames:
frames.a <- add_scalebar(frames)
frames.a[[100]]

# or in white at another position
frames.b <- add_scalebar(frames, colour = "white", position = "bottomright")
frames.b[[100]]

# or with another height
frames.c <- add_scalebar(frames, colour = "white", position = "bottomright", height = 0.025)
frames.c[[100]]
}
}
\seealso{
\code{\link{frames_spatial}} \code{\link{frames_graph}} \code{\link{animate_frames}}
}
\author{
Jakob Schwalb-Willmann
}
